/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.EmailTokenVerifier;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.mail.send.OutgoingEmail;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class RegisterNewEmailSender
extends OutgoingEmail {
    private final EmailTokenVerifier tokenVerifier;
    private final IdentifiedUser user;
    private final String addr;
    private String emailToken;

    @Inject
    public RegisterNewEmailSender(EmailArguments ea, EmailTokenVerifier etv, IdentifiedUser callingUser, @Assisted String address) {
        super(ea, "registernewemail");
        this.tokenVerifier = etv;
        this.user = callingUser;
        this.addr = address;
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        this.setHeader("Subject", "[Gerrit Code Review] Email Verification");
        this.add(RecipientType.TO, new Address(this.addr));
    }

    @Override
    protected void format() throws EmailException {
        this.appendText(this.textTemplate("RegisterNewEmail"));
    }

    public String getUserNameEmail() {
        return this.getUserNameEmailFor(this.user.getAccountId());
    }

    public String getEmailRegistrationToken() {
        if (this.emailToken == null) {
            this.emailToken = Preconditions.checkNotNull(this.tokenVerifier.encode(this.user.getAccountId(), this.addr), "token");
        }
        return this.emailToken;
    }

    public boolean isAllowed() {
        return this.args.emailSender.canEmail(this.addr);
    }

    @Override
    protected void setupSoyContext() {
        super.setupSoyContext();
        this.soyContextEmailData.put("emailRegistrationToken", this.getEmailRegistrationToken());
        this.soyContextEmailData.put("userNameEmail", this.getUserNameEmail());
    }

    public static interface Factory {
        public RegisterNewEmailSender create(String var1);
    }
}

