/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.git.RefCache;
import com.google.gerrit.server.notedb.AutoValue_NoteDbChangeState_Delta;
import com.google.gerrit.server.notedb.AutoValue_NoteDbChangeState_RefState;
import com.google.gwtorm.server.OrmRuntimeException;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;

public class NoteDbChangeState {
    public static final String NOTE_DB_PRIMARY_STATE = "N";
    private final Change.Id changeId;
    private final PrimaryStorage primaryStorage;
    private final Optional<RefState> refState;
    private final Optional<Timestamp> readOnlyUntil;

    public static NoteDbChangeState parse(Change c) {
        return c != null ? NoteDbChangeState.parse(c.getId(), c.getNoteDbState()) : null;
    }

    @VisibleForTesting
    public static NoteDbChangeState parse(Change.Id id, String str) {
        if (Strings.isNullOrEmpty(str)) {
            return null;
        }
        List<String> parts = Splitter.on(',').splitToList(str);
        String first = parts.get(0);
        Optional<Timestamp> readOnlyUntil = NoteDbChangeState.parseReadOnlyUntil(id, str, first);
        if (parts.size() == 1 && first.charAt(0) == PrimaryStorage.NOTE_DB.code) {
            return new NoteDbChangeState(id, PrimaryStorage.NOTE_DB, Optional.empty(), readOnlyUntil);
        }
        if (first.length() > 0) {
            Optional refState = first.charAt(0) == PrimaryStorage.REVIEW_DB.code ? RefState.parse(id, parts.subList(1, parts.size())) : RefState.parse(id, parts);
            return new NoteDbChangeState(id, PrimaryStorage.REVIEW_DB, refState, readOnlyUntil);
        }
        throw NoteDbChangeState.invalidState(id, str);
    }

    private static Optional<Timestamp> parseReadOnlyUntil(Change.Id id, String fullStr, String first) {
        if (first.length() > 2 && first.charAt(1) == '=') {
            Long ts = Longs.tryParse(first.substring(2));
            if (ts == null) {
                throw NoteDbChangeState.invalidState(id, fullStr);
            }
            return Optional.of(new Timestamp(ts));
        }
        return Optional.empty();
    }

    private static IllegalArgumentException invalidState(Change.Id id, String str) {
        return new IllegalArgumentException("invalid state string for change " + id + ": " + str);
    }

    public static NoteDbChangeState applyDelta(Change change, Delta delta) {
        ObjectId changeMetaId;
        if (delta == null) {
            return null;
        }
        String oldStr = change.getNoteDbState();
        if (oldStr == null && !delta.newChangeMetaId().isPresent()) {
            return null;
        }
        NoteDbChangeState oldState = NoteDbChangeState.parse(change.getId(), oldStr);
        if (oldState != null && oldState.getPrimaryStorage() == PrimaryStorage.NOTE_DB) {
            return oldState;
        }
        if (delta.newChangeMetaId().isPresent()) {
            changeMetaId = delta.newChangeMetaId().get();
            if (changeMetaId.equals(ObjectId.zeroId())) {
                change.setNoteDbState(null);
                return null;
            }
        } else {
            changeMetaId = oldState.getChangeMetaId();
        }
        HashMap<Account.Id, ObjectId> draftIds = new HashMap<Account.Id, ObjectId>();
        if (oldState != null) {
            draftIds.putAll(oldState.getDraftIds());
        }
        for (Map.Entry e : delta.newDraftIds().entrySet()) {
            if (((ObjectId)e.getValue()).equals(ObjectId.zeroId())) {
                draftIds.remove(e.getKey());
                continue;
            }
            draftIds.put((Account.Id)e.getKey(), (ObjectId)e.getValue());
        }
        NoteDbChangeState state = new NoteDbChangeState(change.getId(), oldState != null ? oldState.getPrimaryStorage() : PrimaryStorage.REVIEW_DB, Optional.of(RefState.create(changeMetaId, draftIds)), oldState != null ? oldState.getReadOnlyUntil() : Optional.empty());
        change.setNoteDbState(state.toString());
        return state;
    }

    public static boolean isChangeUpToDate(@Nullable NoteDbChangeState state, RefCache changeRepoRefs, Change.Id changeId) throws IOException {
        if (PrimaryStorage.of(state) == PrimaryStorage.NOTE_DB) {
            return true;
        }
        if (state == null) {
            return !changeRepoRefs.get(RefNames.changeMetaRef(changeId)).isPresent();
        }
        return state.isChangeUpToDate(changeRepoRefs);
    }

    public static boolean areDraftsUpToDate(@Nullable NoteDbChangeState state, RefCache draftsRepoRefs, Change.Id changeId, Account.Id accountId) throws IOException {
        if (PrimaryStorage.of(state) == PrimaryStorage.NOTE_DB) {
            return true;
        }
        if (state == null) {
            return !draftsRepoRefs.get(RefNames.refsDraftComments(changeId, accountId)).isPresent();
        }
        return state.areDraftsUpToDate(draftsRepoRefs, accountId);
    }

    public static long getReadOnlySkew(Config cfg) {
        return cfg.getTimeUnit("notedb", null, "maxTimestampSkew", 1000L, TimeUnit.MILLISECONDS);
    }

    static Timestamp timeForReadOnlyCheck(long skewMs) {
        return new Timestamp(TimeUtil.nowMs() - skewMs);
    }

    public static void checkNotReadOnly(@Nullable Change change, long skewMs) {
        NoteDbChangeState.checkNotReadOnly(NoteDbChangeState.parse(change), skewMs);
    }

    public static void checkNotReadOnly(@Nullable NoteDbChangeState state, long skewMs) {
        if (state == null) {
            return;
        }
        if (state.isReadOnly(NoteDbChangeState.timeForReadOnlyCheck(skewMs))) {
            throw new OrmRuntimeException("change " + state.getChangeId() + " is read-only until " + state.getReadOnlyUntil().get());
        }
    }

    public NoteDbChangeState(Change.Id changeId, PrimaryStorage primaryStorage, Optional<RefState> refState, Optional<Timestamp> readOnlyUntil) {
        this.changeId = Preconditions.checkNotNull(changeId);
        this.primaryStorage = Preconditions.checkNotNull(primaryStorage);
        this.refState = Preconditions.checkNotNull(refState);
        this.readOnlyUntil = Preconditions.checkNotNull(readOnlyUntil);
        switch (primaryStorage) {
            case REVIEW_DB: {
                Preconditions.checkArgument(refState.isPresent(), "expected RefState for change %s with primary storage %s", (Object)changeId, (Object)primaryStorage);
                break;
            }
            case NOTE_DB: {
                Preconditions.checkArgument(!refState.isPresent(), "expected no RefState for change %s with primary storage %s", (Object)changeId, (Object)primaryStorage);
                break;
            }
            default: {
                throw new IllegalStateException("invalid PrimaryStorage: " + (Object)((Object)primaryStorage));
            }
        }
    }

    public PrimaryStorage getPrimaryStorage() {
        return this.primaryStorage;
    }

    public boolean isChangeUpToDate(RefCache changeRepoRefs) throws IOException {
        if (this.primaryStorage == PrimaryStorage.NOTE_DB) {
            return true;
        }
        Optional<ObjectId> id = changeRepoRefs.get(RefNames.changeMetaRef(this.changeId));
        if (!id.isPresent()) {
            return this.getChangeMetaId().equals(ObjectId.zeroId());
        }
        return id.get().equals(this.getChangeMetaId());
    }

    public boolean areDraftsUpToDate(RefCache draftsRepoRefs, Account.Id accountId) throws IOException {
        if (this.primaryStorage == PrimaryStorage.NOTE_DB) {
            return true;
        }
        Optional<ObjectId> id = draftsRepoRefs.get(RefNames.refsDraftComments(this.changeId, accountId));
        if (!id.isPresent()) {
            return !this.getDraftIds().containsKey(accountId);
        }
        return id.get().equals(this.getDraftIds().get(accountId));
    }

    public boolean isUpToDate(RefCache changeRepoRefs, RefCache draftsRepoRefs) throws IOException {
        if (this.primaryStorage == PrimaryStorage.NOTE_DB) {
            return true;
        }
        if (!this.isChangeUpToDate(changeRepoRefs)) {
            return false;
        }
        for (Account.Id accountId : this.getDraftIds().keySet()) {
            if (this.areDraftsUpToDate(draftsRepoRefs, accountId)) continue;
            return false;
        }
        return true;
    }

    public boolean isReadOnly(Timestamp now) {
        return this.readOnlyUntil.isPresent() && now.before(this.readOnlyUntil.get());
    }

    public Optional<Timestamp> getReadOnlyUntil() {
        return this.readOnlyUntil;
    }

    public NoteDbChangeState withReadOnlyUntil(Timestamp ts) {
        return new NoteDbChangeState(this.changeId, this.primaryStorage, this.refState, Optional.of(ts));
    }

    public Change.Id getChangeId() {
        return this.changeId;
    }

    public ObjectId getChangeMetaId() {
        return this.refState().changeMetaId();
    }

    public ImmutableMap<Account.Id, ObjectId> getDraftIds() {
        return this.refState().draftIds();
    }

    public Optional<RefState> getRefState() {
        return this.refState;
    }

    private RefState refState() {
        Preconditions.checkState(this.refState.isPresent(), "state for %s has no RefState: %s", (Object)this.changeId, (Object)this);
        return this.refState.get();
    }

    public String toString() {
        switch (this.primaryStorage) {
            case REVIEW_DB: {
                if (!this.readOnlyUntil.isPresent()) {
                    return this.refState().toString();
                }
                return this.primaryStorage.code + "=" + this.readOnlyUntil.get().getTime() + "," + this.refState.get();
            }
            case NOTE_DB: {
                if (!this.readOnlyUntil.isPresent()) {
                    return NOTE_DB_PRIMARY_STATE;
                }
                return this.primaryStorage.code + "=" + this.readOnlyUntil.get().getTime();
            }
        }
        throw new IllegalArgumentException("Unsupported PrimaryStorage: " + (Object)((Object)this.primaryStorage));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changeId, this.primaryStorage, this.refState, this.readOnlyUntil});
    }

    public boolean equals(Object o) {
        if (!(o instanceof NoteDbChangeState)) {
            return false;
        }
        NoteDbChangeState s = (NoteDbChangeState)o;
        return this.changeId.equals(s.changeId) && this.primaryStorage.equals((Object)s.primaryStorage) && this.refState.equals(s.refState) && this.readOnlyUntil.equals(s.readOnlyUntil);
    }

    @AutoValue
    public static abstract class RefState {
        @VisibleForTesting
        public static RefState create(ObjectId changeMetaId, Map<Account.Id, ObjectId> draftIds) {
            return new AutoValue_NoteDbChangeState_RefState(changeMetaId.copy(), ImmutableMap.copyOf(Maps.filterValues(draftIds, id -> !ObjectId.zeroId().equals((AnyObjectId)id))));
        }

        private static Optional<RefState> parse(Change.Id changeId, List<String> parts) {
            Preconditions.checkArgument(!parts.isEmpty(), "missing state string for change %s", (Object)changeId);
            ObjectId changeMetaId = ObjectId.fromString(parts.get(0));
            HashMap<Account.Id, ObjectId> draftIds = Maps.newHashMapWithExpectedSize(parts.size() - 1);
            Splitter s = Splitter.on('=');
            for (int i = 1; i < parts.size(); ++i) {
                String p = parts.get(i);
                List<String> draftParts = s.splitToList(p);
                Preconditions.checkArgument(draftParts.size() == 2, "invalid draft state part for change %s: %s", (Object)changeId, (Object)p);
                draftIds.put(Account.Id.parse(draftParts.get(0)), ObjectId.fromString(draftParts.get(1)));
            }
            return Optional.of(RefState.create(changeMetaId, draftIds));
        }

        abstract ObjectId changeMetaId();

        abstract ImmutableMap<Account.Id, ObjectId> draftIds();

        public String toString() {
            return this.appendTo(new StringBuilder()).toString();
        }

        StringBuilder appendTo(StringBuilder sb) {
            sb.append(this.changeMetaId().name());
            for (Account.Id id : ReviewDbUtil.intKeyOrdering().sortedCopy(this.draftIds().keySet())) {
                sb.append(',').append(id.get()).append('=').append(this.draftIds().get(id).name());
            }
            return sb;
        }
    }

    @AutoValue
    public static abstract class Delta {
        @VisibleForTesting
        public static Delta create(Change.Id changeId, Optional<ObjectId> newChangeMetaId, Map<Account.Id, ObjectId> newDraftIds) {
            if (newDraftIds == null) {
                newDraftIds = ImmutableMap.of();
            }
            return new AutoValue_NoteDbChangeState_Delta(changeId, newChangeMetaId, ImmutableMap.copyOf(newDraftIds));
        }

        abstract Change.Id changeId();

        abstract Optional<ObjectId> newChangeMetaId();

        abstract ImmutableMap<Account.Id, ObjectId> newDraftIds();
    }

    public static enum PrimaryStorage {
        REVIEW_DB('R'),
        NOTE_DB('N');

        private final char code;

        private PrimaryStorage(char code) {
            this.code = code;
        }

        public static PrimaryStorage of(Change c) {
            return PrimaryStorage.of(NoteDbChangeState.parse(c));
        }

        public static PrimaryStorage of(NoteDbChangeState s) {
            return s != null ? s.getPrimaryStorage() : REVIEW_DB;
        }
    }
}

