/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.gerrit.extensions.client.ReviewerState;
import java.util.Arrays;
import org.eclipse.jgit.revwalk.FooterKey;

public enum ReviewerStateInternal {
    REVIEWER(new FooterKey("Reviewer"), ReviewerState.REVIEWER),
    CC(new FooterKey("CC"), ReviewerState.CC),
    REMOVED(new FooterKey("Removed"), ReviewerState.REMOVED);

    private final FooterKey footerKey;
    private final ReviewerState state;

    private ReviewerStateInternal(FooterKey footerKey, ReviewerState state) {
        this.footerKey = footerKey;
        this.state = state;
    }

    FooterKey getFooterKey() {
        return this.footerKey;
    }

    public ReviewerState asReviewerState() {
        return this.state;
    }

    static {
        boolean ok = true;
        if (ReviewerStateInternal.values().length != ReviewerState.values().length) {
            ok = false;
        }
        for (ReviewerStateInternal s : ReviewerStateInternal.values()) {
            ok &= s.name().equals(s.state.name());
        }
        if (!ok) {
            throw new IllegalStateException("Mismatched reviewer state mapping: " + Arrays.asList(ReviewerStateInternal.values()) + " != " + Arrays.asList(ReviewerState.values()));
        }
    }
}

