/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSerialization;

public class PatchListKey
implements Serializable {
    public static final long serialVersionUID = 24L;
    public static final ImmutableBiMap<DiffPreferencesInfo.Whitespace, Character> WHITESPACE_TYPES = ImmutableBiMap.of(DiffPreferencesInfo.Whitespace.IGNORE_NONE, Character.valueOf('N'), DiffPreferencesInfo.Whitespace.IGNORE_TRAILING, Character.valueOf('E'), DiffPreferencesInfo.Whitespace.IGNORE_LEADING_AND_TRAILING, Character.valueOf('S'), DiffPreferencesInfo.Whitespace.IGNORE_ALL, Character.valueOf('A'));
    private transient ObjectId oldId;
    private transient Integer parentNum;
    private transient ObjectId newId;
    private transient DiffPreferencesInfo.Whitespace whitespace;

    public static PatchListKey againstDefaultBase(AnyObjectId newId, DiffPreferencesInfo.Whitespace ws) {
        return new PatchListKey(null, newId, ws);
    }

    public static PatchListKey againstParentNum(int parentNum, AnyObjectId newId, DiffPreferencesInfo.Whitespace ws) {
        return new PatchListKey(parentNum, newId, ws);
    }

    public PatchListKey(AnyObjectId a, AnyObjectId b, DiffPreferencesInfo.Whitespace ws) {
        this.oldId = a != null ? a.copy() : null;
        this.newId = b.copy();
        this.whitespace = ws;
    }

    private PatchListKey(int parentNum, AnyObjectId b, DiffPreferencesInfo.Whitespace ws) {
        this.parentNum = parentNum;
        this.newId = b.copy();
        this.whitespace = ws;
    }

    PatchListKey(ObjectId oldId, Integer parentNum, ObjectId newId, DiffPreferencesInfo.Whitespace whitespace) {
        this.oldId = oldId;
        this.parentNum = parentNum;
        this.newId = newId;
        this.whitespace = whitespace;
    }

    @Nullable
    public ObjectId getOldId() {
        return this.oldId;
    }

    @Nullable
    public Integer getParentNum() {
        return this.parentNum;
    }

    public ObjectId getNewId() {
        return this.newId;
    }

    public DiffPreferencesInfo.Whitespace getWhitespace() {
        return this.whitespace;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.oldId, this.parentNum, this.newId, this.whitespace});
    }

    public boolean equals(Object o) {
        if (o instanceof PatchListKey) {
            PatchListKey k = (PatchListKey)o;
            return Objects.equals(this.oldId, k.oldId) && Objects.equals(this.parentNum, k.parentNum) && Objects.equals(this.newId, k.newId) && this.whitespace == k.whitespace;
        }
        return false;
    }

    public String toString() {
        StringBuilder n = new StringBuilder();
        n.append("PatchListKey[");
        n.append(this.oldId != null ? this.oldId.name() : "BASE");
        n.append("..");
        n.append(this.newId.name());
        n.append(" ");
        if (this.parentNum != null) {
            n.append(this.parentNum);
            n.append(" ");
        }
        n.append(this.whitespace.name());
        n.append("]");
        return n.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectIdSerialization.writeCanBeNull(out, this.oldId);
        out.writeInt(this.parentNum == null ? 0 : this.parentNum);
        ObjectIdSerialization.writeNotNull(out, this.newId);
        Character c = (Character)WHITESPACE_TYPES.get((Object)this.whitespace);
        if (c == null) {
            throw new IOException("Invalid whitespace type: " + (Object)((Object)this.whitespace));
        }
        out.writeChar(c.charValue());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.oldId = ObjectIdSerialization.readCanBeNull(in);
        int n = in.readInt();
        this.parentNum = n == 0 ? null : Integer.valueOf(n);
        this.newId = ObjectIdSerialization.readNotNull(in);
        char t = in.readChar();
        this.whitespace = (DiffPreferencesInfo.Whitespace)((Object)((ImmutableMap)((Object)WHITESPACE_TYPES.inverse())).get(Character.valueOf(t)));
        if (this.whitespace == null) {
            throw new IOException("Invalid whitespace type code: " + t);
        }
    }

    static {
        Preconditions.checkState(WHITESPACE_TYPES.size() == DiffPreferencesInfo.Whitespace.values().length);
    }
}

