/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.extensions.annotations.Export;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.PluginContentScanner;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;

public abstract class AbstractPreloadedPluginScanner
implements PluginContentScanner {
    protected final String pluginName;
    protected final String pluginVersion;
    protected final Set<Class<?>> preloadedClasses;
    protected final Plugin.ApiType apiType;
    private Class<?> sshModuleClass;
    private Class<?> httpModuleClass;
    private Class<?> sysModuleClass;

    public AbstractPreloadedPluginScanner(String pluginName, String pluginVersion, Set<Class<?>> preloadedClasses, Plugin.ApiType apiType) {
        this.pluginName = pluginName;
        this.pluginVersion = pluginVersion;
        this.preloadedClasses = preloadedClasses;
        this.apiType = apiType;
    }

    @Override
    public Manifest getManifest() throws IOException {
        this.scanGuiceModules(this.preloadedClasses);
        StringBuilder manifestString = new StringBuilder("PluginName: " + this.pluginName + "\nImplementation-Version: " + this.pluginVersion + "\nGerrit-ReloadMode: restart\nGerrit-ApiType: " + (Object)((Object)this.apiType) + "\n");
        this.appendIfNotNull(manifestString, "Gerrit-SshModule: ", this.sshModuleClass);
        this.appendIfNotNull(manifestString, "Gerrit-HttpModule: ", this.httpModuleClass);
        this.appendIfNotNull(manifestString, "Gerrit-Module: ", this.sysModuleClass);
        return new Manifest(new ByteArrayInputStream(manifestString.toString().getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public Map<Class<? extends Annotation>, Iterable<PluginContentScanner.ExtensionMetaData>> scan(String pluginName, Iterable<Class<? extends Annotation>> annotations) throws InvalidPluginException {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Class<? extends Annotation> annotation : annotations) {
            HashSet<PluginContentScanner.ExtensionMetaData> classMetaDataSet = new HashSet<PluginContentScanner.ExtensionMetaData>();
            result.put(annotation, classMetaDataSet);
            for (Class<?> clazz : this.preloadedClasses) {
                if (Modifier.isAbstract(clazz.getModifiers()) || clazz.getAnnotation(annotation) == null) continue;
                classMetaDataSet.add(new PluginContentScanner.ExtensionMetaData(clazz.getName(), this.getExportAnnotationValue(clazz, annotation)));
            }
        }
        return result.build();
    }

    private void appendIfNotNull(StringBuilder string, String header, Class<?> guiceModuleClass) {
        if (guiceModuleClass != null) {
            string.append(header);
            string.append(guiceModuleClass.getName());
            string.append("\n");
        }
    }

    private void scanGuiceModules(Set<Class<?>> classes) throws IOException {
        try {
            Class<Module> sysModuleBaseClass = Module.class;
            Class<ServletModule> httpModuleBaseClass = ServletModule.class;
            Class<?> sshModuleBaseClass = Class.forName("com.google.gerrit.sshd.CommandModule");
            this.sshModuleClass = null;
            this.httpModuleClass = null;
            this.sysModuleClass = null;
            for (Class<?> clazz : classes) {
                if (clazz.isLocalClass()) continue;
                if (sshModuleBaseClass.isAssignableFrom(clazz)) {
                    this.sshModuleClass = this.getUniqueGuiceModule(sshModuleBaseClass, this.sshModuleClass, clazz);
                    continue;
                }
                if (httpModuleBaseClass.isAssignableFrom(clazz)) {
                    this.httpModuleClass = this.getUniqueGuiceModule(httpModuleBaseClass, this.httpModuleClass, clazz);
                    continue;
                }
                if (!sysModuleBaseClass.isAssignableFrom(clazz)) continue;
                this.sysModuleClass = this.getUniqueGuiceModule(sysModuleBaseClass, this.sysModuleClass, clazz);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot find base Gerrit classes for Guice Plugin Modules", e);
        }
    }

    private Class<?> getUniqueGuiceModule(Class<?> guiceModuleBaseClass, Class<?> existingGuiceModuleName, Class<?> newGuiceModuleClass) {
        Preconditions.checkState(existingGuiceModuleName == null, "Multiple %s implementations: %s, %s", guiceModuleBaseClass, existingGuiceModuleName, newGuiceModuleClass);
        return newGuiceModuleClass;
    }

    private String getExportAnnotationValue(Class<?> scriptClass, Class<? extends Annotation> annotation) {
        return annotation == Export.class ? scriptClass.getAnnotation(Export.class).value() : "";
    }
}

