/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.RawInput;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.plugins.ListPlugins;
import com.google.gerrit.server.plugins.PluginInstallException;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gerrit.server.plugins.PluginResource;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.zip.ZipException;

@RequiresCapability(value="administrateServer")
class InstallPlugin
implements RestModifyView<TopLevelResource, Input> {
    private final PluginLoader loader;
    private final String name;
    private final boolean created;

    InstallPlugin(PluginLoader loader, String name, boolean created) {
        this.loader = loader;
        this.name = name;
        this.created = created;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response<ListPlugins.PluginInfo> apply(TopLevelResource resource, Input input) throws BadRequestException, MethodNotAllowedException, IOException {
        if (!this.loader.isRemoteAdminEnabled()) {
            throw new MethodNotAllowedException("remote installation is disabled");
        }
        try (InputStream in = this.openStream(input);){
            String pluginName = this.loader.installPluginFromStream(this.name, in);
            ListPlugins.PluginInfo info = new ListPlugins.PluginInfo(this.loader.get(pluginName));
            Response<ListPlugins.PluginInfo> response = this.created ? Response.created(info) : Response.ok(info);
            return response;
        }
        catch (PluginInstallException e) {
            StringWriter buf = new StringWriter();
            buf.write(String.format("cannot install %s", this.name));
            if (e.getCause() instanceof ZipException) {
                buf.write(": ");
                buf.write(e.getCause().getMessage());
                throw new BadRequestException(buf.toString());
            }
            buf.write(":\n");
            PrintWriter pw = new PrintWriter(buf);
            e.printStackTrace(pw);
            pw.flush();
            throw new BadRequestException(buf.toString());
        }
    }

    private InputStream openStream(Input input) throws IOException, BadRequestException {
        if (input.raw != null) {
            return input.raw.getInputStream();
        }
        try {
            return new URL(input.url).openStream();
        }
        catch (IOException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    @RequiresCapability(value="administrateServer")
    static class Overwrite
    implements RestModifyView<PluginResource, Input> {
        private final PluginLoader loader;

        @Inject
        Overwrite(PluginLoader loader) {
            this.loader = loader;
        }

        public Response<ListPlugins.PluginInfo> apply(PluginResource resource, Input input) throws BadRequestException, MethodNotAllowedException, IOException {
            return new InstallPlugin(this.loader, resource.getName(), false).apply(TopLevelResource.INSTANCE, input);
        }
    }

    static class Input {
        @DefaultInput
        String url;
        RawInput raw;

        Input() {
        }
    }
}

