/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.CommitResource;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class CommitsCollection
implements ChildCollection<ProjectResource, CommitResource> {
    private final DynamicMap<RestView<CommitResource>> views;
    private final GitRepositoryManager repoManager;
    private final Provider<ReviewDb> db;

    @Inject
    public CommitsCollection(DynamicMap<RestView<CommitResource>> views, GitRepositoryManager repoManager, Provider<ReviewDb> db) {
        this.views = views;
        this.repoManager = repoManager;
        this.db = db;
    }

    @Override
    public RestView<ProjectResource> list() throws ResourceNotFoundException {
        throw new ResourceNotFoundException();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public CommitResource parse(ProjectResource parent, IdString id) throws ResourceNotFoundException, IOException {
        ObjectId objectId;
        try {
            objectId = ObjectId.fromString(id.get());
        }
        catch (IllegalArgumentException e) {
            throw new ResourceNotFoundException(id);
        }
        try {
            Throwable throwable = null;
            try (Repository repo = this.repoManager.openRepository(parent.getNameKey());){
                CommitResource commitResource;
                RevWalk rw = new RevWalk(repo);
                Throwable throwable2 = null;
                try {
                    RevCommit commit = rw.parseCommit(objectId);
                    rw.parseBody(commit);
                    if (!parent.getControl().canReadCommit(this.db.get(), repo, commit)) {
                        throw new ResourceNotFoundException(id);
                    }
                    for (int i = 0; i < commit.getParentCount(); ++i) {
                        rw.parseBody(rw.parseCommit(commit.getParent(i)));
                    }
                    commitResource = new CommitResource(parent, commit);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            CommitsCollection.$closeResource(throwable2, rw);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                CommitsCollection.$closeResource(throwable2, rw);
                return commitResource;
            }
        }
        catch (IncorrectObjectTypeException | MissingObjectException e) {
            throw new ResourceNotFoundException(id);
        }
    }

    @Override
    public DynamicMap<RestView<CommitResource>> views() {
        return this.views;
    }
}

