/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.project.DeleteRef;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.project.RefUtil;
import com.google.gerrit.server.project.TagResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class DeleteTag
implements RestModifyView<TagResource, Input> {
    private final DeleteRef.Factory deleteRefFactory;

    @Inject
    DeleteTag(DeleteRef.Factory deleteRefFactory) {
        this.deleteRefFactory = deleteRefFactory;
    }

    public Response<?> apply(TagResource resource, Input input) throws OrmException, RestApiException, IOException {
        String tag = RefUtil.normalizeTagRef(resource.getTagInfo().ref);
        RefControl refControl = resource.getControl().controlForRef(tag);
        if (!refControl.canDelete()) {
            throw new AuthException("Cannot delete tag");
        }
        this.deleteRefFactory.create(resource).ref(tag).delete();
        return Response.none();
    }

    public static class Input {
    }
}

