/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

public class FileResource
implements RestResource {
    public static final TypeLiteral<RestView<FileResource>> FILE_KIND = new TypeLiteral<RestView<FileResource>>(){};
    private final ProjectControl project;
    private final ObjectId rev;
    private final String path;

    public static FileResource create(GitRepositoryManager repoManager, ProjectControl project, ObjectId rev, String path) throws ResourceNotFoundException, IOException {
        try (Repository repo = repoManager.openRepository(project.getProject().getNameKey());
             RevWalk rw = new RevWalk(repo);){
            RevTree tree = rw.parseTree(rev);
            if (TreeWalk.forPath(repo, path, tree) != null) {
                FileResource fileResource = new FileResource(project, rev, path);
                return fileResource;
            }
        }
        throw new ResourceNotFoundException(IdString.fromDecoded(path));
    }

    public FileResource(ProjectControl project, ObjectId rev, String path) {
        this.project = project;
        this.rev = rev;
        this.path = path;
    }

    public ProjectControl getProject() {
        return this.project;
    }

    public ObjectId getRev() {
        return this.rev;
    }

    public String getPath() {
        return this.path;
    }
}

