/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.gerrit.server.query.AndPredicate;
import com.google.gerrit.server.query.Matchable;
import com.google.gerrit.server.query.NotPredicate;
import com.google.gerrit.server.query.OrPredicate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class Predicate<T> {
    public static <T> Predicate<T> any() {
        return Any.INSTANCE;
    }

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<T> ... that) {
        if (that.length == 1) {
            return that[0];
        }
        return new AndPredicate<T>(that);
    }

    public static <T> Predicate<T> and(Collection<? extends Predicate<T>> that) {
        if (that.size() == 1) {
            return Iterables.getOnlyElement(that);
        }
        return new AndPredicate(that);
    }

    @SafeVarargs
    public static <T> Predicate<T> or(Predicate<T> ... that) {
        if (that.length == 1) {
            return that[0];
        }
        return new OrPredicate<T>(that);
    }

    public static <T> Predicate<T> or(Collection<? extends Predicate<T>> that) {
        if (that.size() == 1) {
            return Iterables.getOnlyElement(that);
        }
        return new OrPredicate(that);
    }

    public static <T> Predicate<T> not(Predicate<T> that) {
        if (that instanceof NotPredicate) {
            return that.getChild(0);
        }
        return new NotPredicate<T>(that);
    }

    public List<Predicate<T>> getChildren() {
        return Collections.emptyList();
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    public Predicate<T> getChild(int i) {
        return this.getChildren().get(i);
    }

    public abstract Predicate<T> copy(Collection<? extends Predicate<T>> var1);

    public boolean isMatchable() {
        return this instanceof Matchable;
    }

    public Matchable<T> asMatchable() {
        Preconditions.checkState(this.isMatchable(), "not matchable");
        return (Matchable)((Object)this);
    }

    public int estimateCost() {
        if (!this.isMatchable()) {
            return 1;
        }
        return this.asMatchable().getCost();
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    private static class Any<T>
    extends Predicate<T>
    implements Matchable<T> {
        private static final Any<Object> INSTANCE = new Any();

        private Any() {
        }

        @Override
        public Predicate<T> copy(Collection<? extends Predicate<T>> children) {
            return this;
        }

        @Override
        public boolean match(T object) {
            return true;
        }

        @Override
        public int getCost() {
            return 0;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object other) {
            return other == this;
        }
    }
}

