/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.IsVisibleToPredicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;

class ChangeIsVisibleToPredicate
extends IsVisibleToPredicate<ChangeData> {
    private final Provider<ReviewDb> db;
    private final ChangeNotes.Factory notesFactory;
    private final ChangeControl.GenericFactory changeControl;
    private final CurrentUser user;

    ChangeIsVisibleToPredicate(Provider<ReviewDb> db, ChangeNotes.Factory notesFactory, ChangeControl.GenericFactory changeControlFactory, CurrentUser user) {
        super("visibleto", ChangeIsVisibleToPredicate.describe(user));
        this.db = db;
        this.notesFactory = notesFactory;
        this.changeControl = changeControlFactory;
        this.user = user;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        if (cd.fastIsVisibleTo(this.user)) {
            return true;
        }
        try {
            Change c = cd.change();
            if (c == null) {
                return false;
            }
            ChangeNotes notes = this.notesFactory.createFromIndexedChange(c);
            ChangeControl cc = this.changeControl.controlFor(notes, this.user);
            if (cc.isVisible(this.db.get(), cd)) {
                cd.cacheVisibleTo(cc);
                return true;
            }
        }
        catch (NoSuchChangeException noSuchChangeException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

