/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.base.Preconditions;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.index.IndexConfig;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.index.QueryOptions;
import com.google.gerrit.server.index.change.ChangeIndexCollection;
import com.google.gerrit.server.index.change.ChangeIndexRewriter;
import com.google.gerrit.server.index.change.ChangeSchemaDefinitions;
import com.google.gerrit.server.index.change.IndexedChangeQuery;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryProcessor;
import com.google.gerrit.server.query.change.AndChangeSource;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIsVisibleToPredicate;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Set;

public class ChangeQueryProcessor
extends QueryProcessor<ChangeData> {
    private final Provider<ReviewDb> db;
    private final ChangeControl.GenericFactory changeControlFactory;
    private final ChangeNotes.Factory notesFactory;

    @Inject
    ChangeQueryProcessor(Provider<CurrentUser> userProvider, QueryProcessor.Metrics metrics, IndexConfig indexConfig, ChangeIndexCollection indexes, ChangeIndexRewriter rewriter, Provider<ReviewDb> db, ChangeControl.GenericFactory changeControlFactory, ChangeNotes.Factory notesFactory) {
        super(userProvider, metrics, ChangeSchemaDefinitions.INSTANCE, indexConfig, indexes, rewriter, "limit");
        this.db = db;
        this.changeControlFactory = changeControlFactory;
        this.notesFactory = notesFactory;
    }

    public ChangeQueryProcessor enforceVisibility(boolean enforce) {
        super.enforceVisibility(enforce);
        return this;
    }

    @Override
    protected QueryOptions createOptions(IndexConfig indexConfig, int start, int limit, Set<String> requestedFields) {
        return IndexedChangeQuery.createOptions(indexConfig, start, limit, requestedFields);
    }

    @Override
    protected Predicate<ChangeData> enforceVisibility(Predicate<ChangeData> pred) {
        return new AndChangeSource(pred, new ChangeIsVisibleToPredicate(this.db, this.notesFactory, this.changeControlFactory, (CurrentUser)this.userProvider.get()), this.start);
    }

    static {
        Preconditions.checkState(!ChangeIsVisibleToPredicate.class.isAssignableFrom(IndexPredicate.class), "ChangeQueryProcessor assumes visibleto is not used by the index rewriter.");
    }
}

