/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;
import java.util.Objects;

class CommentByPredicate
extends ChangeIndexPredicate {
    private final Account.Id id;

    CommentByPredicate(Account.Id id) {
        super(ChangeField.COMMENTBY, id.toString());
        this.id = id;
    }

    Account.Id getAccountId() {
        return this.id;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        for (ChangeMessage m : cd.messages()) {
            if (!Objects.equals(m.getAuthor(), this.id)) continue;
            return true;
        }
        for (Comment c : cd.publishedComments()) {
            if (!Objects.equals(c.author.getId(), this.id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

