/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.ChangeStatusPredicate;
import com.google.gwtorm.server.OrmException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ReviewerPredicate
extends ChangeIndexPredicate {
    private final ReviewerStateInternal state;
    private final Account.Id id;

    static Predicate<ChangeData> reviewer(ChangeQueryBuilder.Arguments args, Account.Id id) {
        ReviewerPredicate p = args.notesMigration.readChanges() ? new ReviewerPredicate(ReviewerStateInternal.REVIEWER, id) : ReviewerPredicate.anyReviewerState(id);
        return ReviewerPredicate.create(args, p);
    }

    static Predicate<ChangeData> cc(ChangeQueryBuilder.Arguments args, Account.Id id) {
        return ReviewerPredicate.create(args, new ReviewerPredicate(ReviewerStateInternal.CC, id));
    }

    private static Predicate<ChangeData> anyReviewerState(Account.Id id) {
        return Predicate.or(Stream.of(ReviewerStateInternal.values()).filter(s -> s != ReviewerStateInternal.REMOVED).map(s -> new ReviewerPredicate((ReviewerStateInternal)((Object)s), id)).collect(Collectors.toList()));
    }

    private static Predicate<ChangeData> create(ChangeQueryBuilder.Arguments args, Predicate<ChangeData> p) {
        if (!args.allowsDrafts) {
            return Predicate.and(p, Predicate.not(new ChangeStatusPredicate(Change.Status.DRAFT)));
        }
        return p;
    }

    private ReviewerPredicate(ReviewerStateInternal state, Account.Id id) {
        super(ChangeField.REVIEWER, ChangeField.getReviewerFieldValue(state, id));
        this.state = state;
        this.id = id;
    }

    Account.Id getAccountId() {
        return this.id;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        return cd.reviewers().asTable().get((Object)this.state, this.id) != null;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

