/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.server.config.ConfigSection;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.schema.BaseDataSourceType;
import com.google.gerrit.server.schema.JdbcUtil;
import com.google.gerrit.server.schema.ScriptRunner;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.lib.Config;

class PostgreSQL
extends BaseDataSourceType {
    private Config cfg;

    @Inject
    PostgreSQL(@GerritServerConfig Config cfg) {
        super("org.postgresql.Driver");
        this.cfg = cfg;
    }

    @Override
    public String getUrl() {
        StringBuilder b = new StringBuilder();
        ConfigSection dbc = new ConfigSection(this.cfg, "database");
        b.append("jdbc:postgresql://");
        b.append(JdbcUtil.hostname(dbc.optional("hostname")));
        b.append(JdbcUtil.port(dbc.optional("port")));
        b.append("/");
        b.append(dbc.required("database"));
        return b.toString();
    }

    @Override
    public ScriptRunner getIndexScript() throws IOException {
        return PostgreSQL.getScriptRunner("index_postgres.sql");
    }
}

