/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.update;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.config.FactoryModule;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.validators.OnSubmitValidators;
import com.google.gerrit.server.update.BatchUpdateListener;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChainedReceiveCommands;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.InsertChangeOp;
import com.google.gerrit.server.update.Order;
import com.google.gerrit.server.update.RepoOnlyOp;
import com.google.gerrit.server.update.ReviewDbBatchUpdate;
import com.google.gerrit.server.update.UpdateException;
import com.google.gerrit.server.util.RequestId;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchUpdate
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(BatchUpdate.class);
    protected GitRepositoryManager repoManager;
    protected final Project.NameKey project;
    protected final CurrentUser user;
    protected final Timestamp when;
    protected final TimeZone tz;
    protected final ListMultimap<Change.Id, BatchUpdateOp> ops = MultimapBuilder.linkedHashKeys().arrayListValues().build();
    protected final Map<Change.Id, Change> newChanges = new HashMap<Change.Id, Change>();
    protected final List<RepoOnlyOp> repoOnlyOps = new ArrayList<RepoOnlyOp>();
    protected Repository repo;
    protected ObjectInserter inserter;
    protected RevWalk revWalk;
    protected ChainedReceiveCommands commands;
    protected BatchRefUpdate batchRefUpdate;
    protected Order order;
    protected OnSubmitValidators onSubmitValidators;
    protected RequestId requestId;
    protected String refLogMessage;
    private boolean updateChangesInParallel;
    private boolean closeRepo;

    public static Module module() {
        return new FactoryModule(){

            @Override
            public void configure() {
                this.factory(ReviewDbBatchUpdate.AssistedFactory.class);
            }
        };
    }

    protected static Order getOrder(Collection<? extends BatchUpdate> updates) {
        Order o = null;
        for (BatchUpdate batchUpdate : updates) {
            if (o == null) {
                o = batchUpdate.order;
                continue;
            }
            if (batchUpdate.order == o) continue;
            throw new IllegalArgumentException("cannot mix execution orders");
        }
        return o;
    }

    protected static boolean getUpdateChangesInParallel(Collection<? extends BatchUpdate> updates) {
        Preconditions.checkArgument(!updates.isEmpty());
        Boolean p = null;
        for (BatchUpdate batchUpdate : updates) {
            if (p == null) {
                p = batchUpdate.updateChangesInParallel;
                continue;
            }
            if (batchUpdate.updateChangesInParallel == p) continue;
            throw new IllegalArgumentException("cannot mix parallel and non-parallel operations");
        }
        Preconditions.checkArgument(p == false || updates.size() <= 1, "cannot execute ChangeOps in parallel with more than 1 BatchUpdate");
        return p;
    }

    protected BatchUpdate(GitRepositoryManager repoManager, PersonIdent serverIdent, Project.NameKey project, CurrentUser user, Timestamp when) {
        this.repoManager = repoManager;
        this.project = project;
        this.user = user;
        this.when = when;
        this.tz = serverIdent.getTimeZone();
        this.order = Order.REPO_BEFORE_DB;
    }

    @Override
    public void close() {
        if (this.closeRepo) {
            this.revWalk.getObjectReader().close();
            this.revWalk.close();
            this.inserter.close();
            this.repo.close();
        }
    }

    public abstract void execute(BatchUpdateListener var1) throws UpdateException, RestApiException;

    public abstract void execute() throws UpdateException, RestApiException;

    protected abstract Context newContext();

    public BatchUpdate setRequestId(RequestId requestId) {
        this.requestId = requestId;
        return this;
    }

    public BatchUpdate setRepository(Repository repo, RevWalk revWalk, ObjectInserter inserter) {
        Preconditions.checkState(this.repo == null, "repo already set");
        this.closeRepo = false;
        this.repo = Preconditions.checkNotNull(repo, "repo");
        this.revWalk = Preconditions.checkNotNull(revWalk, "revWalk");
        this.inserter = Preconditions.checkNotNull(inserter, "inserter");
        this.commands = new ChainedReceiveCommands(repo);
        return this;
    }

    public BatchUpdate setRefLogMessage(String refLogMessage) {
        this.refLogMessage = refLogMessage;
        return this;
    }

    public BatchUpdate setOrder(Order order) {
        this.order = order;
        return this;
    }

    public BatchUpdate setOnSubmitValidators(OnSubmitValidators onSubmitValidators) {
        this.onSubmitValidators = onSubmitValidators;
        return this;
    }

    public BatchUpdate updateChangesInParallel() {
        this.updateChangesInParallel = true;
        return this;
    }

    protected void initRepository() throws IOException {
        if (this.repo == null) {
            this.repo = this.repoManager.openRepository(this.project);
            this.closeRepo = true;
            this.inserter = this.repo.newObjectInserter();
            this.revWalk = new RevWalk(this.inserter.newReader());
            this.commands = new ChainedReceiveCommands(this.repo);
        }
    }

    protected CurrentUser getUser() {
        return this.user;
    }

    protected Repository getRepository() throws IOException {
        this.initRepository();
        return this.repo;
    }

    protected RevWalk getRevWalk() throws IOException {
        this.initRepository();
        return this.revWalk;
    }

    protected ObjectInserter getObjectInserter() throws IOException {
        this.initRepository();
        return this.inserter;
    }

    public Collection<ReceiveCommand> getRefUpdates() {
        return this.commands.getCommands().values();
    }

    public BatchUpdate addOp(Change.Id id, BatchUpdateOp op) {
        Preconditions.checkArgument(!(op instanceof InsertChangeOp), "use insertChange");
        Preconditions.checkNotNull(op);
        this.ops.put(id, op);
        return this;
    }

    public BatchUpdate addRepoOnlyOp(RepoOnlyOp op) {
        Preconditions.checkArgument(!(op instanceof BatchUpdateOp), "use addOp()");
        this.repoOnlyOps.add(op);
        return this;
    }

    public BatchUpdate insertChange(InsertChangeOp op) {
        Context ctx = this.newContext();
        Change c = op.createChange(ctx);
        Preconditions.checkArgument(!this.newChanges.containsKey(c.getId()), "only one op allowed to create change %s", (Object)c.getId());
        this.newChanges.put(c.getId(), c);
        this.ops.get((Object)c.getId()).add(0, op);
        return this;
    }

    protected void logDebug(String msg, Throwable t) {
        if (this.requestId != null && log.isDebugEnabled()) {
            log.debug(this.requestId + msg, t);
        }
    }

    protected void logDebug(String msg, Object ... args) {
        if (this.requestId != null && log.isDebugEnabled()) {
            log.debug(this.requestId + msg, args);
        }
    }

    @Singleton
    public static class Factory {
        private final ReviewDbBatchUpdate.AssistedFactory reviewDbBatchUpdateFactory;

        @Inject
        Factory(ReviewDbBatchUpdate.AssistedFactory reviewDbBatchUpdateFactory) {
            this.reviewDbBatchUpdateFactory = reviewDbBatchUpdateFactory;
        }

        public BatchUpdate create(ReviewDb db, Project.NameKey project, CurrentUser user, Timestamp when) {
            return this.reviewDbBatchUpdateFactory.create(db, project, user, when);
        }

        public void execute(Collection<BatchUpdate> updates, BatchUpdateListener listener, @Nullable RequestId requestId, boolean dryRun) throws UpdateException, RestApiException {
            ImmutableList<BatchUpdate> reviewDbUpdates = ImmutableList.copyOf(updates);
            ReviewDbBatchUpdate.execute(reviewDbUpdates, listener, requestId, dryRun);
        }
    }
}

