/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.ThreadSettingsConfig;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.git.WorkQueue;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.ThreadFactory;
import org.eclipse.jgit.lib.Config;

@Singleton
public class CommandExecutorQueueProvider
implements QueueProvider {
    private int poolSize;
    private final int batchThreads;
    private final WorkQueue.Executor interactiveExecutor;
    private final WorkQueue.Executor batchExecutor;

    @Inject
    public CommandExecutorQueueProvider(@GerritServerConfig Config config, ThreadSettingsConfig threadsSettingsConfig, WorkQueue queues) {
        this.poolSize = threadsSettingsConfig.getSshdThreads();
        this.batchThreads = config.getInt("sshd", "batchThreads", threadsSettingsConfig.getSshdBatchTreads());
        if (this.batchThreads > this.poolSize) {
            this.poolSize += this.batchThreads;
        }
        int interactiveThreads = Math.max(1, this.poolSize - this.batchThreads);
        this.interactiveExecutor = queues.createQueue(interactiveThreads, "SSH-Interactive-Worker", true);
        if (this.batchThreads != 0) {
            this.batchExecutor = queues.createQueue(this.batchThreads, "SSH-Batch-Worker", true);
            this.setThreadFactory(this.batchExecutor);
        } else {
            this.batchExecutor = this.interactiveExecutor;
        }
        this.setThreadFactory(this.interactiveExecutor);
    }

    private void setThreadFactory(WorkQueue.Executor executor) {
        final ThreadFactory parent = executor.getThreadFactory();
        executor.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable task) {
                Thread t = parent.newThread(task);
                t.setPriority(1);
                return t;
            }
        });
    }

    @Override
    public WorkQueue.Executor getQueue(QueueProvider.QueueType type) {
        switch (type) {
            case INTERACTIVE: {
                return this.interactiveExecutor;
            }
        }
        return this.batchExecutor;
    }
}

