/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.extensions.api.projects.BranchInput;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import org.kohsuke.args4j.Argument;

@CommandMetaData(name="create-branch", description="Create a new branch")
public final class CreateBranchCommand
extends SshCommand {
    @Argument(index=0, required=true, metaVar="PROJECT", usage="name of the project")
    private ProjectControl project;
    @Argument(index=1, required=true, metaVar="NAME", usage="name of branch to be created")
    private String name;
    @Argument(index=2, required=true, metaVar="REVISION", usage="base revision of the new branch")
    private String revision;
    @Inject
    GerritApi gApi;

    @Override
    protected void run() throws BaseCommand.UnloggedFailure {
        try {
            BranchInput in = new BranchInput();
            in.revision = this.revision;
            this.gApi.projects().name(this.project.getProject().getNameKey().get()).branch(this.name).create(in);
        }
        catch (RestApiException e) {
            throw this.die(e);
        }
    }
}

