/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.i18n;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import javax.annotation.Nullable;

public final class BidiGlobalDir {
    public static final BidiGlobalDir LTR = new BidiGlobalDir(1);
    public static final BidiGlobalDir RTL = new BidiGlobalDir(-1);
    private final String codeSnippet;
    @Nullable
    private final String namespace;
    private final int staticValue;

    private BidiGlobalDir(int staticValue) {
        this.staticValue = staticValue;
        this.codeSnippet = Integer.toString(staticValue);
        this.namespace = null;
    }

    private BidiGlobalDir(String codeSnippet, @Nullable String namespaceToImport) {
        this.codeSnippet = Preconditions.checkNotNull(codeSnippet);
        this.namespace = namespaceToImport;
        this.staticValue = 0;
    }

    public static BidiGlobalDir forStaticIsRtl(boolean isRtl) {
        return isRtl ? RTL : LTR;
    }

    public static BidiGlobalDir forStaticLocale(@Nullable String localeString) {
        return SoyBidiUtils.getBidiGlobalDir(localeString);
    }

    public static BidiGlobalDir forIsRtlCodeSnippet(String isRtlCodeSnippet, @Nullable String namespace, SoyBackendKind backend) {
        Preconditions.checkArgument(isRtlCodeSnippet != null && isRtlCodeSnippet.length() > 0, "Bidi global direction source code snippet must be non-empty.");
        Preconditions.checkArgument(backend == SoyBackendKind.JS_SRC || backend == SoyBackendKind.PYTHON_SRC, "Bidi code snippets are only used in JS and Python.");
        if (backend == SoyBackendKind.JS_SRC) {
            return new BidiGlobalDir(isRtlCodeSnippet + "?-1:1", namespace);
        }
        return new BidiGlobalDir("-1 if " + isRtlCodeSnippet + " else 1", namespace);
    }

    public boolean isStaticValue() {
        return this.staticValue != 0;
    }

    public int getStaticValue() {
        if (this.staticValue == 0) {
            throw new RuntimeException("Cannot get static value for nonstatic BidiGlobalDir object.");
        }
        return this.staticValue;
    }

    public String getCodeSnippet() {
        return this.codeSnippet;
    }

    public Optional<String> getNamespace() {
        return Optional.fromNullable(this.namespace);
    }
}

