/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.TypeInfo;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class LocalVariable
extends Expression {
    private final String variableName;
    private final int index;
    private final Label start;
    private final Label end;

    static LocalVariable createThisVar(TypeInfo owner, Label start, Label end) {
        return new LocalVariable("this", owner.type(), 0, start, end, Expression.Feature.NON_NULLABLE);
    }

    static LocalVariable createLocal(String name, int index, Type type, Label start, Label end) {
        Preconditions.checkArgument(!name.equals("this"));
        return new LocalVariable(name, type, index, start, end, new Expression.Feature[0]);
    }

    private LocalVariable(String variableName, Type type, int index, Label start, Label end, Expression.Feature ... features) {
        super(type, Expression.Feature.CHEAP, features);
        this.variableName = Preconditions.checkNotNull(variableName);
        this.index = index;
        this.start = Preconditions.checkNotNull(start);
        this.end = Preconditions.checkNotNull(end);
    }

    String variableName() {
        return this.variableName;
    }

    int index() {
        return this.index;
    }

    Label start() {
        return this.start;
    }

    Label end() {
        return this.end;
    }

    @Override
    LocalVariable asCheap() {
        return this;
    }

    @Override
    LocalVariable asNonNullable() {
        if (this.isNonNullable()) {
            return this;
        }
        return new LocalVariable(this.variableName, this.resultType(), this.index, this.start, this.end, Expression.Feature.NON_NULLABLE);
    }

    void tableEntry(CodeBuilder mv) {
        mv.visitLocalVariable(this.variableName(), this.resultType().getDescriptor(), null, this.start(), this.end(), this.index());
    }

    @Override
    void doGen(CodeBuilder mv) {
        mv.visitVarInsn(this.resultType().getOpcode(21), this.index());
    }

    Statement store(Expression expr) {
        return this.store(expr, Optional.absent());
    }

    Statement store(Expression expr, Label firstVarInstruction) {
        return this.store(expr, Optional.of(firstVarInstruction));
    }

    private Statement store(final Expression expr, final Optional<Label> firstVarInstruction) {
        expr.checkAssignableTo(this.resultType());
        return new Statement(){

            @Override
            void doGen(CodeBuilder adapter) {
                expr.gen(adapter);
                if (firstVarInstruction.isPresent()) {
                    adapter.mark((Label)firstVarInstruction.get());
                }
                adapter.visitVarInsn(LocalVariable.this.resultType().getOpcode(54), LocalVariable.this.index());
            }
        };
    }
}

