/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.SoyParsingContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CommandTextAttributesParser {
    public static final SoyErrorKind MALFORMED_ATTRIBUTES = SoyErrorKind.of("Malformed attributes in ''{0}'' command text ({1}).");
    public static final SoyErrorKind UNSUPPORTED_ATTRIBUTE = SoyErrorKind.of("Unsupported attribute ''{0}'' in ''{1}'' command text ({2}).");
    private static final SoyErrorKind DUPLICATE_ATTRIBUTE = SoyErrorKind.of("Duplicate attribute ''{0}'' in ''{1}'' command text ({2}).");
    private static final SoyErrorKind INVALID_ATTRIBUTE_VALUE = SoyErrorKind.of("Invalid value for attribute ''{0}'' in ''{1}'' command text ({2}). Valid values are {3}.");
    private static final SoyErrorKind MISSING_REQUIRED_ATTRIBUTE = SoyErrorKind.of("Missing required attribute ''{0}'' in ''{1}'' command text ({2}).");
    private static final Pattern ATTRIBUTE_TEXT = Pattern.compile("([a-zA-Z][a-zA-Z0-9-]*) \\s* = \\s* \" ( (?:[^\"\\\\]+ | \\\\.)*+ ) \" \\s*", 36);
    private static final Pattern ATTRIBUTE_VALUE_ESCAPE = Pattern.compile("\\\\([\"\\\\])");
    private final String commandName;
    private final Set<Attribute> supportedAttributes;
    private final Set<String> supportedAttributeNames;

    CommandTextAttributesParser(String commandName, Attribute ... supportedAttributes) {
        this.commandName = commandName;
        this.supportedAttributes = ImmutableSet.copyOf(supportedAttributes);
        ImmutableSet.Builder supportedAttributeNamesBuilder = ImmutableSet.builder();
        for (Attribute attribute : supportedAttributes) {
            supportedAttributeNamesBuilder.add(attribute.name);
            if (attribute.allowedValues == Attribute.ALLOW_ALL_VALUES || attribute.defaultValue == null || "__NDVBR__".equals(attribute.defaultValue)) continue;
            Preconditions.checkArgument(attribute.allowedValues.contains(attribute.defaultValue));
        }
        this.supportedAttributeNames = supportedAttributeNamesBuilder.build();
    }

    Map<String, String> parse(String commandText, SoyParsingContext context, SourceLocation sourceLocation) {
        return this.parse(commandText, context.errorReporter(), sourceLocation);
    }

    Map<String, String> parse(String commandText, ErrorReporter errorReporter, SourceLocation sourceLocation) {
        HashMap<String, String> attributes = Maps.newHashMap();
        int i = 0;
        Matcher matcher = ATTRIBUTE_TEXT.matcher(commandText);
        while (matcher.find(i)) {
            if (matcher.start() != i) {
                errorReporter.report(sourceLocation, MALFORMED_ATTRIBUTES, this.commandName, commandText);
            }
            i = matcher.end();
            String name = matcher.group(1);
            String value = matcher.group(2);
            value = ATTRIBUTE_VALUE_ESCAPE.matcher(value).replaceAll("$1");
            if (!this.supportedAttributeNames.contains(name)) {
                errorReporter.report(sourceLocation, UNSUPPORTED_ATTRIBUTE, name, this.commandName, commandText);
            }
            if (attributes.containsKey(name)) {
                errorReporter.report(sourceLocation, DUPLICATE_ATTRIBUTE, name, this.commandName, commandText);
            }
            attributes.put(name, value);
        }
        if (i != commandText.length()) {
            errorReporter.report(sourceLocation, MALFORMED_ATTRIBUTES, this.commandName, commandText);
        }
        for (Attribute supportedAttribute : this.supportedAttributes) {
            if (attributes.containsKey(supportedAttribute.name)) {
                if (supportedAttribute.allowedValues == Attribute.ALLOW_ALL_VALUES || supportedAttribute.allowedValues.contains(attributes.get(supportedAttribute.name))) continue;
                errorReporter.report(sourceLocation, INVALID_ATTRIBUTE_VALUE, supportedAttribute.name, this.commandName, commandText, supportedAttribute.allowedValues.toString());
                continue;
            }
            if ("__NDVBR__".equals(supportedAttribute.defaultValue)) {
                errorReporter.report(sourceLocation, MISSING_REQUIRED_ATTRIBUTE, supportedAttribute.name, this.commandName, commandText);
            }
            attributes.put(supportedAttribute.name, supportedAttribute.defaultValue);
        }
        return attributes;
    }

    public static class Attribute {
        public static final Collection<String> ALLOW_ALL_VALUES = null;
        public static final Collection<String> BOOLEAN_VALUES = ImmutableSet.of("true", "false");
        public static final String NO_DEFAULT_VALUE_BECAUSE_REQUIRED = "__NDVBR__";
        final String name;
        final Collection<String> allowedValues;
        final String defaultValue;

        public Attribute(String name, Collection<String> allowedValues, String defaultValue) {
            this.name = name;
            this.allowedValues = allowedValues;
            this.defaultValue = defaultValue;
        }
    }
}

