/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Ascii;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.soytree.ExprUnionEquivalence;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import javax.annotation.Nullable;

public final class TagName {
    private final SoyNode.StandaloneNode node;
    @Nullable
    private final String nameAsLowerCase;
    @Nullable
    private final SpecialTagName specialTagName;

    public TagName(RawTextNode node) {
        this.node = Preconditions.checkNotNull(node);
        switch (this.nameAsLowerCase = Ascii.toLowerCase(node.getRawText())) {
            case "script": {
                this.specialTagName = SpecialTagName.SCRIPT;
                break;
            }
            case "style": {
                this.specialTagName = SpecialTagName.STYLE;
                break;
            }
            case "textarea": {
                this.specialTagName = SpecialTagName.TEXTAREA;
                break;
            }
            case "title": {
                this.specialTagName = SpecialTagName.TITLE;
                break;
            }
            default: {
                this.specialTagName = null;
            }
        }
    }

    public TagName(PrintNode node) {
        this.node = Preconditions.checkNotNull(node);
        this.nameAsLowerCase = null;
        this.specialTagName = null;
    }

    public boolean isStatic() {
        return this.node instanceof RawTextNode;
    }

    @Nullable
    public SpecialTagName getSpecialTagName() {
        return this.specialTagName;
    }

    public RawTextNode getStaticTagName() {
        Preconditions.checkState(this.isStatic());
        return (RawTextNode)this.node;
    }

    public Optional<String> getStaticTagNameAsLowerCase() {
        return Optional.fromNullable(this.nameAsLowerCase);
    }

    public SoyNode.StandaloneNode getNode() {
        return this.node;
    }

    public PrintNode getDynamicTagName() {
        Preconditions.checkState(!this.isStatic());
        return (PrintNode)this.node;
    }

    public SourceLocation getTagLocation() {
        return this.node.getSourceLocation();
    }

    public boolean equals(Object other) {
        if (other instanceof TagName) {
            TagName tag = (TagName)other;
            if (this.isStatic() != tag.isStatic()) {
                return false;
            }
            if (this.isStatic()) {
                return this.nameAsLowerCase.equals(tag.nameAsLowerCase);
            }
            return this.comparePrintNode((PrintNode)this.node, (PrintNode)tag.node);
        }
        return false;
    }

    private boolean comparePrintNode(PrintNode firstNode, PrintNode secondNode) {
        ExprUnionEquivalence exprUnionEquivalence = ExprUnionEquivalence.get();
        if (!exprUnionEquivalence.equivalent(firstNode.getExprUnion(), secondNode.getExprUnion())) {
            return false;
        }
        List firstNodeDirectives = firstNode.getChildren();
        List secondNodeDirectives = secondNode.getChildren();
        if (firstNodeDirectives.size() != secondNodeDirectives.size()) {
            return false;
        }
        for (int i = 0; i < firstNodeDirectives.size(); ++i) {
            if (((PrintDirectiveNode)firstNodeDirectives.get(i)).getName().equals(((PrintDirectiveNode)secondNodeDirectives.get(i)).getName())) {
                return false;
            }
            if (exprUnionEquivalence.pairwise().equivalent(((PrintDirectiveNode)firstNodeDirectives.get(i)).getAllExprUnions(), ((PrintDirectiveNode)secondNodeDirectives.get(i)).getAllExprUnions())) continue;
            return false;
        }
        return true;
    }

    private static int hashPrintNode(PrintNode node) {
        ExprUnionEquivalence exprUnionEquivalence = ExprUnionEquivalence.get();
        int hc = exprUnionEquivalence.hash(node.getExprUnion());
        for (PrintDirectiveNode child : node.getChildren()) {
            hc = 31 * hc + child.getName().hashCode();
            hc = 31 * hc + exprUnionEquivalence.pairwise().hash(child.getAllExprUnions());
        }
        return hc;
    }

    public int hashCode() {
        return this.isStatic() ? this.nameAsLowerCase.hashCode() : TagName.hashPrintNode((PrintNode)this.node);
    }

    public String toString() {
        return this.node.toSourceString();
    }

    public static enum SpecialTagName {
        SCRIPT,
        STYLE,
        TITLE,
        TEXTAREA;


        public String toString() {
            return Ascii.toLowerCase(this.name());
        }
    }
}

