/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.Undoable;

public final class Trail {
    private Undoable[] buffer;
    private int top;
    long timeStamp;

    public Trail() {
        this(100);
    }

    public Trail(int n) {
        this.buffer = new Undoable[n];
        this.top = -1;
    }

    public void init() {
        this.deleteAll();
    }

    public void push(Undoable undoable) {
        if (++this.top >= this.buffer.length) {
            int n = this.buffer.length;
            Undoable[] undoableArray = new Undoable[2 * n];
            System.arraycopy(this.buffer, 0, undoableArray, 0, n);
            this.buffer = undoableArray;
        }
        this.buffer[this.top] = undoable;
    }

    public Undoable pop() {
        Undoable undoable = this.buffer[this.top];
        this.buffer[this.top--] = null;
        return undoable;
    }

    protected void deleteAll() {
        while (!this.empty()) {
            this.buffer[this.top--] = null;
        }
    }

    public boolean empty() {
        return this.top == -1;
    }

    public int max() {
        return this.buffer.length;
    }

    public int top() {
        return this.top;
    }

    public void unwind(int n) {
        while (this.top > n) {
            Undoable undoable = this.pop();
            undoable.undo();
        }
    }
}

