/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.MemoMismatchesMatcher;
import org.parboiled.trees.ImmutableGraphNode;

public abstract class AbstractMatcher
extends ImmutableGraphNode<Matcher>
implements Matcher,
Cloneable {
    private String label;
    private boolean nodeSuppressed;
    private boolean subnodesSuppressed;
    private boolean nodeSkipped;
    private Object tag;

    public AbstractMatcher(String label) {
        this(new Rule[0], label);
    }

    public AbstractMatcher(Rule subRule, String label) {
        this(new Rule[]{Preconditions.checkNotNull(subRule, "subRule")}, label);
    }

    public AbstractMatcher(Rule[] subRules, String label) {
        super(ImmutableList.copyOf(AbstractMatcher.toMatchers(Preconditions.checkNotNull(subRules))));
        this.label = label;
    }

    private static Matcher[] toMatchers(Rule ... subRules) {
        Matcher[] matchers = new Matcher[subRules.length];
        for (int i = 0; i < subRules.length; ++i) {
            matchers[i] = (Matcher)subRules[i];
        }
        return matchers;
    }

    @Override
    public boolean isNodeSuppressed() {
        return this.nodeSuppressed;
    }

    @Override
    public boolean areSubnodesSuppressed() {
        return this.subnodesSuppressed;
    }

    @Override
    public boolean isNodeSkipped() {
        return this.nodeSkipped;
    }

    @Override
    public boolean areMismatchesMemoed() {
        return false;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean hasCustomLabel() {
        return true;
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public AbstractMatcher label(String label) {
        if (Objects.equal(label, this.label)) {
            return this;
        }
        AbstractMatcher clone = this.createClone();
        clone.label = label;
        return clone;
    }

    @Override
    public Rule suppressNode() {
        if (this.nodeSuppressed) {
            return this;
        }
        AbstractMatcher clone = this.createClone();
        clone.nodeSuppressed = true;
        return clone;
    }

    @Override
    public Rule suppressSubnodes() {
        if (this.subnodesSuppressed) {
            return this;
        }
        AbstractMatcher clone = this.createClone();
        clone.subnodesSuppressed = true;
        return clone;
    }

    @Override
    public Rule skipNode() {
        if (this.nodeSkipped) {
            return this;
        }
        AbstractMatcher clone = this.createClone();
        clone.nodeSkipped = true;
        return clone;
    }

    @Override
    public Rule memoMismatches() {
        return new MemoMismatchesMatcher(this);
    }

    @Override
    public Object getTag() {
        return this.tag;
    }

    @Override
    public void setTag(Object tagObject) {
        this.tag = tagObject;
    }

    @Override
    public <V> MatcherContext<V> getSubContext(MatcherContext<V> context) {
        return context.getSubContext(this);
    }

    private AbstractMatcher createClone() {
        try {
            return (AbstractMatcher)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

