/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import com.google.common.base.Preconditions;
import org.parboiled.MatcherContext;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;
import org.parboiled.support.Characters;

public class AnyOfMatcher
extends AbstractMatcher {
    public final Characters characters;

    public AnyOfMatcher(Characters characters) {
        super(Preconditions.checkNotNull(characters, "characters").toString());
        Preconditions.checkArgument(!characters.equals(Characters.NONE));
        this.characters = characters;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (!this.characters.contains(context.getCurrentChar())) {
            return false;
        }
        context.advanceIndex(1);
        context.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkNotNull(visitor, "visitor");
        return visitor.visit(this);
    }
}

