/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.github.parboiled1.grappa.transform.asm.LoadingOpcode;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.common.Factory;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.process.RuleMethodProcessor;

public class RuleMethodRewriter
implements RuleMethodProcessor {
    private RuleMethod method;
    private int actionNr = 0;
    private int varInitNr = 0;

    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull(classNode, "classNode");
        Preconditions.checkNotNull(method, "method");
        return method.containsExplicitActions() || method.containsVars();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        this.method = Preconditions.checkNotNull(method, "method");
        this.actionNr = 0;
        this.varInitNr = 0;
        for (InstructionGroup group : method.getGroups()) {
            this.createNewGroupClassInstance(group);
            this.initializeFields(group);
            InstructionGraphNode root = group.getRoot();
            if (root.isActionRoot()) {
                this.removeGroupRootInstruction(group);
                continue;
            }
            ((MethodInsnNode)root.getInstruction()).desc = CodegenUtils.sig(Void.TYPE, Factory.class);
        }
        method.setBodyRewritten();
    }

    private void createNewGroupClassInstance(InstructionGroup group) {
        String internalName = group.getGroupClassType().getInternalName();
        InstructionGraphNode root = group.getRoot();
        this.insert(group, new TypeInsnNode(187, internalName));
        this.insert(group, new InsnNode(89));
        this.insert(group, new LdcInsnNode(this.method.name + (root.isActionRoot() ? "_Action" + ++this.actionNr : "_VarInit" + ++this.varInitNr)));
        this.insert(group, new MethodInsnNode(183, internalName, "<init>", CodegenUtils.sig(Void.TYPE, String.class), false));
        if (root.isActionRoot() && this.method.hasSkipActionsInPredicatesAnnotation()) {
            this.insert(group, new InsnNode(89));
            this.insert(group, new MethodInsnNode(182, internalName, "setSkipInPredicates", CodegenUtils.sig(Void.TYPE, new Class[0]), false));
        }
    }

    private void initializeFields(InstructionGroup group) {
        String internalName = group.getGroupClassType().getInternalName();
        for (FieldNode field : group.getFields()) {
            this.insert(group, new InsnNode(89));
            int opcode = LoadingOpcode.forType((Type)field.value);
            this.insert(group, new VarInsnNode(opcode, field.access));
            this.insert(group, new FieldInsnNode(181, internalName, field.name, field.desc));
        }
    }

    private void insert(InstructionGroup group, AbstractInsnNode insn) {
        this.method.instructions.insertBefore(group.getRoot().getInstruction(), insn);
    }

    private void removeGroupRootInstruction(InstructionGroup group) {
        this.method.instructions.remove(group.getRoot().getInstruction());
    }
}

