/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupInfo;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.WebLinkInfoCommon;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProjectAccess {
    protected Project.NameKey projectName;
    protected String revision;
    protected Project.NameKey inheritsFrom;
    protected List<AccessSection> local;
    protected Set<String> ownerOf;
    protected boolean isConfigVisible;
    protected boolean canUpload;
    protected LabelTypes labelTypes;
    protected Map<String, String> capabilities;
    protected Map<AccountGroup.UUID, GroupInfo> groupInfo;
    protected List<WebLinkInfoCommon> fileHistoryLinks;

    public Project.NameKey getProjectName() {
        return this.projectName;
    }

    public void setProjectName(Project.NameKey projectName) {
        this.projectName = projectName;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String name) {
        this.revision = name;
    }

    public Project.NameKey getInheritsFrom() {
        return this.inheritsFrom;
    }

    public void setInheritsFrom(Project.NameKey name) {
        this.inheritsFrom = name;
    }

    public List<AccessSection> getLocal() {
        return this.local;
    }

    public void setLocal(List<AccessSection> as) {
        this.local = as;
    }

    public AccessSection getLocal(String name) {
        for (AccessSection s : this.local) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public boolean isOwnerOf(AccessSection section) {
        return this.isOwnerOf(section.getName());
    }

    public boolean isOwnerOf(String name) {
        return this.ownerOf.contains(name);
    }

    public Set<String> getOwnerOf() {
        return this.ownerOf;
    }

    public void setOwnerOf(Set<String> refs) {
        this.ownerOf = refs;
    }

    public boolean isConfigVisible() {
        return this.isConfigVisible;
    }

    public void setConfigVisible(boolean isConfigVisible) {
        this.isConfigVisible = isConfigVisible;
    }

    public boolean canUpload() {
        return this.canUpload;
    }

    public void setCanUpload(boolean canUpload) {
        this.canUpload = canUpload;
    }

    public LabelTypes getLabelTypes() {
        return this.labelTypes;
    }

    public void setLabelTypes(LabelTypes labelTypes) {
        this.labelTypes = labelTypes;
    }

    public Map<String, String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Map<String, String> capabilities) {
        this.capabilities = capabilities;
    }

    public Map<AccountGroup.UUID, GroupInfo> getGroupInfo() {
        return this.groupInfo;
    }

    public void setGroupInfo(Map<AccountGroup.UUID, GroupInfo> m) {
        this.groupInfo = m;
    }

    public void setFileHistoryLinks(List<WebLinkInfoCommon> links) {
        this.fileHistoryLinks = links;
    }

    public List<WebLinkInfoCommon> getFileHistoryLinks() {
        return this.fileHistoryLinks;
    }
}

