/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.template;

import com.google.common.base.Strings;
import com.google.gerrit.common.FileUtil;
import com.google.gerrit.httpd.HtmlDomUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class SiteHeaderFooter {
    private static final Logger log = LoggerFactory.getLogger(SiteHeaderFooter.class);
    private final boolean refreshHeaderFooter;
    private final SitePaths sitePaths;
    private volatile Template template;

    @Inject
    SiteHeaderFooter(@GerritServerConfig Config cfg, SitePaths sitePaths) {
        this.refreshHeaderFooter = cfg.getBoolean("site", "refreshHeaderFooter", true);
        this.sitePaths = sitePaths;
        try {
            Template t = new Template(sitePaths);
            t.load();
            this.template = t;
        }
        catch (IOException e) {
            log.warn("Cannot load site header or footer", e);
        }
    }

    public Document parse(Class<?> clazz, String name) throws IOException {
        Template t = this.template;
        if (this.refreshHeaderFooter && t.isStale()) {
            t = new Template(this.sitePaths);
            try {
                t.load();
                this.template = t;
            }
            catch (IOException e) {
                log.warn("Cannot refresh site header or footer", e);
                t = this.template;
            }
        }
        Document doc = HtmlDomUtil.parseFile(clazz, name);
        this.injectCss(doc, "gerrit_sitecss", t.css);
        this.injectXml(doc, "gerrit_header", t.header);
        this.injectXml(doc, "gerrit_footer", t.footer);
        return doc;
    }

    private void injectCss(Document doc, String id, String content) {
        Element e = HtmlDomUtil.find(doc, id);
        if (e != null) {
            if (!Strings.isNullOrEmpty(content)) {
                while (e.getFirstChild() != null) {
                    e.removeChild(e.getFirstChild());
                }
                e.removeAttribute("id");
                e.appendChild(doc.createCDATASection("\n" + content + "\n"));
            } else {
                e.getParentNode().removeChild(e);
            }
        }
    }

    private void injectXml(Document doc, String id, Element d) {
        Element e = HtmlDomUtil.find(doc, id);
        if (e != null) {
            if (d != null) {
                while (e.getFirstChild() != null) {
                    e.removeChild(e.getFirstChild());
                }
                e.appendChild(doc.importNode(d, true));
            } else {
                e.getParentNode().removeChild(e);
            }
        }
    }

    private static class FileInfo {
        final Path path;
        final long time;

        FileInfo(Path p) {
            this.path = p;
            this.time = FileUtil.lastModified(p);
        }

        boolean isStale() {
            return this.time != FileUtil.lastModified(this.path);
        }
    }

    private static class Template {
        private final FileInfo cssFile;
        private final FileInfo headerFile;
        private final FileInfo footerFile;
        String css;
        Element header;
        Element footer;

        Template(SitePaths site) {
            this.cssFile = new FileInfo(site.site_css);
            this.headerFile = new FileInfo(site.site_header);
            this.footerFile = new FileInfo(site.site_footer);
        }

        void load() throws IOException {
            this.css = HtmlDomUtil.readFile(this.cssFile.path.getParent(), this.cssFile.path.getFileName().toString());
            this.header = Template.readXml(this.headerFile);
            this.footer = Template.readXml(this.footerFile);
        }

        boolean isStale() {
            return this.cssFile.isStale() || this.headerFile.isStale() || this.footerFile.isStale();
        }

        private static Element readXml(FileInfo src) throws IOException {
            Document d = HtmlDomUtil.parseFile(src.path);
            return d != null ? d.getDocumentElement() : null;
        }
    }
}

