/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics.dropwizard;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Field;
import com.google.gerrit.metrics.dropwizard.BucketedMetric;
import com.google.gerrit.metrics.dropwizard.CallbackMetricImpl0;
import com.google.gerrit.metrics.dropwizard.DropWizardMetricMaker;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class BucketedCallback<V>
implements BucketedMetric {
    private final DropWizardMetricMaker metrics;
    private final MetricRegistry registry;
    private final String name;
    private final Description.FieldOrdering ordering;
    protected final Field<?>[] fields;
    private final V zero;
    private final Map<Object, ValueGauge> cells;
    protected volatile Runnable trigger;
    private final Object lock = new Object();

    BucketedCallback(DropWizardMetricMaker metrics, MetricRegistry registry, String name, Class<V> valueType, Description desc, Field<?> ... fields) {
        this.metrics = metrics;
        this.registry = registry;
        this.name = name;
        this.ordering = desc.getFieldOrdering();
        this.fields = fields;
        this.zero = CallbackMetricImpl0.zeroFor(valueType);
        this.cells = new ConcurrentHashMap<Object, ValueGauge>();
    }

    void doRemove() {
        for (Object key : this.cells.keySet()) {
            this.registry.remove(this.submetric(key));
        }
        this.metrics.remove(this.name);
    }

    void doBeginSet() {
        for (ValueGauge g : this.cells.values()) {
            g.set = false;
        }
    }

    void doPrune() {
        Iterator<Map.Entry<Object, ValueGauge>> i = this.cells.entrySet().iterator();
        while (i.hasNext()) {
            if (i.next().getValue().set) continue;
            i.remove();
        }
    }

    void doEndSet() {
        for (ValueGauge g : this.cells.values()) {
            if (g.set) continue;
            g.value = this.zero;
        }
    }

    ValueGauge getOrCreate(Object f1, Object f2) {
        return this.getOrCreate(ImmutableList.of(f1, f2));
    }

    ValueGauge getOrCreate(Object f1, Object f2, Object f3) {
        return this.getOrCreate(ImmutableList.of(f1, f2, f3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueGauge getOrCreate(Object key) {
        ValueGauge c = this.cells.get(key);
        if (c != null) {
            return c;
        }
        Object object = this.lock;
        synchronized (object) {
            c = this.cells.get(key);
            if (c == null) {
                c = new ValueGauge();
                this.registry.register(this.submetric(key), c);
                this.cells.put(key, c);
            }
            return c;
        }
    }

    private String submetric(Object key) {
        return DropWizardMetricMaker.name(this.ordering, this.name, this.name(key));
    }

    abstract String name(Object var1);

    @Override
    public Metric getTotal() {
        return null;
    }

    @Override
    public Field<?>[] getFields() {
        return this.fields;
    }

    public Map<Object, Metric> getCells() {
        return Maps.transformValues(this.cells, in -> in);
    }

    final class ValueGauge
    implements Gauge<V> {
        volatile V value;
        boolean set;

        ValueGauge() {
            this.value = BucketedCallback.this.zero;
        }

        @Override
        public V getValue() {
            Runnable t = BucketedCallback.this.trigger;
            if (t != null) {
                t.run();
            }
            return this.value;
        }
    }
}

