/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.StringKey;
import java.util.Objects;

public final class AccountExternalId {
    public static final String SCHEME_GERRIT = "gerrit:";
    public static final String SCHEME_UUID = "uuid:";
    public static final String SCHEME_MAILTO = "mailto:";
    public static final String SCHEME_USERNAME = "username:";
    public static final String SCHEME_GPGKEY = "gpgkey:";
    public static final String SCHEME_EXTERNAL = "external:";
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected Account.Id accountId;
    @Column(id=3, notNull=false)
    protected String emailAddress;
    @Column(id=4, notNull=false)
    protected String password;
    protected boolean trusted;
    protected boolean canDelete;

    protected AccountExternalId() {
    }

    public AccountExternalId(Account.Id who, Key k) {
        this.accountId = who;
        this.key = k;
    }

    public Key getKey() {
        return this.key;
    }

    public Account.Id getAccountId() {
        return this.accountId;
    }

    public String getExternalId() {
        return this.key.externalId;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String e) {
        this.emailAddress = e;
    }

    public boolean isScheme(String scheme) {
        String id = this.getExternalId();
        return id != null && id.startsWith(scheme);
    }

    public String getSchemeRest() {
        String scheme = this.key.getScheme();
        return null != scheme ? this.getExternalId().substring(scheme.length() + 1) : null;
    }

    public void setPassword(String hashed) {
        this.password = hashed;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean t) {
        this.trusted = t;
    }

    public boolean canDelete() {
        return this.canDelete;
    }

    public void setCanDelete(boolean t) {
        this.canDelete = t;
    }

    public boolean equals(Object o) {
        if (o instanceof AccountExternalId) {
            AccountExternalId extId = (AccountExternalId)o;
            return Objects.equals(this.key, extId.key) && Objects.equals(this.accountId, extId.accountId) && Objects.equals(this.emailAddress, extId.emailAddress) && Objects.equals(this.password, extId.password);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.accountId, this.emailAddress, this.password);
    }

    public static class Key
    extends StringKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected String externalId;

        protected Key() {
        }

        public Key(String scheme, String identity) {
            if (!scheme.endsWith(":")) {
                scheme = scheme + ":";
            }
            this.externalId = scheme + identity;
        }

        public Key(String e) {
            this.externalId = e;
        }

        @Override
        public String get() {
            return this.externalId;
        }

        @Override
        protected void set(String newValue) {
            this.externalId = newValue;
        }

        public String getScheme() {
            int c = this.externalId.indexOf(58);
            return 0 < c ? this.externalId.substring(0, c) : null;
        }
    }
}

