/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.primitives.Ints;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.ChangeTriplet;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@Singleton
public class ChangeFinder {
    private final Provider<InternalChangeQuery> queryProvider;

    @Inject
    ChangeFinder(Provider<InternalChangeQuery> queryProvider) {
        this.queryProvider = queryProvider;
    }

    public ChangeControl findOne(String id, CurrentUser user) throws OrmException {
        List<ChangeControl> ctls = this.find(id, user);
        if (ctls.size() != 1) {
            return null;
        }
        return ctls.get(0);
    }

    public List<ChangeControl> find(String id, CurrentUser user) throws OrmException {
        Integer n;
        InternalChangeQuery query = this.queryProvider.get().noFields();
        if (!id.isEmpty() && id.charAt(0) != '0' && (n = Ints.tryParse(id)) != null) {
            return this.asChangeControls(query.byLegacyChangeId(new Change.Id(n)), user);
        }
        if (id.matches("^([0-9a-fA-F]{7,40})$")) {
            return this.asChangeControls(query.byCommit(id), user);
        }
        if (!id.contains("~")) {
            return this.asChangeControls(query.byKeyPrefix(id), user);
        }
        Optional<ChangeTriplet> triplet = ChangeTriplet.parse(id);
        if (triplet.isPresent()) {
            return this.asChangeControls(query.byBranchKey(triplet.get().branch(), triplet.get().id()), user);
        }
        return Collections.emptyList();
    }

    public ChangeControl findOne(Change.Id id, CurrentUser user) throws OrmException {
        List<ChangeControl> ctls = this.find(id, user);
        if (ctls.size() != 1) {
            throw new NoSuchChangeException(id);
        }
        return ctls.get(0);
    }

    public List<ChangeControl> find(Change.Id id, CurrentUser user) throws OrmException {
        InternalChangeQuery query = this.queryProvider.get().noFields();
        return this.asChangeControls(query.byLegacyChangeId(id), user);
    }

    private List<ChangeControl> asChangeControls(List<ChangeData> cds, CurrentUser user) throws OrmException {
        ArrayList<ChangeControl> ctls = new ArrayList<ChangeControl>(cds.size());
        for (ChangeData cd : cds) {
            ctls.add(cd.changeControl(user));
        }
        return ctls;
    }
}

