/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.audit.AuditService;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.common.errors.InvalidSshKeyException;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.api.accounts.AccountInput;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountByEmailCache;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.account.ExternalIdsUpdate;
import com.google.gerrit.server.account.VersionedAuthorizedKeys;
import com.google.gerrit.server.api.accounts.AccountExternalIdCreator;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.mail.send.OutgoingEmailValidator;
import com.google.gerrit.server.ssh.SshKeyCache;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;

@RequiresCapability(value="createAccount")
public class CreateAccount
implements RestModifyView<TopLevelResource, AccountInput> {
    private final ReviewDb db;
    private final Provider<IdentifiedUser> currentUser;
    private final GroupsCollection groupsCollection;
    private final VersionedAuthorizedKeys.Accessor authorizedKeys;
    private final SshKeyCache sshKeyCache;
    private final AccountCache accountCache;
    private final AccountByEmailCache byEmailCache;
    private final AccountLoader.Factory infoLoader;
    private final DynamicSet<AccountExternalIdCreator> externalIdCreators;
    private final AuditService auditService;
    private final ExternalIdsUpdate.User externalIdsUpdateFactory;
    private final String username;

    @Inject
    CreateAccount(ReviewDb db, Provider<IdentifiedUser> currentUser, GroupsCollection groupsCollection, VersionedAuthorizedKeys.Accessor authorizedKeys, SshKeyCache sshKeyCache, AccountCache accountCache, AccountByEmailCache byEmailCache, AccountLoader.Factory infoLoader, DynamicSet<AccountExternalIdCreator> externalIdCreators, AuditService auditService, ExternalIdsUpdate.User externalIdsUpdateFactory, @Assisted String username) {
        this.db = db;
        this.currentUser = currentUser;
        this.groupsCollection = groupsCollection;
        this.authorizedKeys = authorizedKeys;
        this.sshKeyCache = sshKeyCache;
        this.accountCache = accountCache;
        this.byEmailCache = byEmailCache;
        this.infoLoader = infoLoader;
        this.externalIdCreators = externalIdCreators;
        this.auditService = auditService;
        this.externalIdsUpdateFactory = externalIdsUpdateFactory;
        this.username = username;
    }

    public Response<AccountInfo> apply(TopLevelResource rsrc, AccountInput input) throws BadRequestException, ResourceConflictException, UnprocessableEntityException, OrmException, IOException, ConfigInvalidException {
        if (input == null) {
            input = new AccountInput();
        }
        if (input.username != null && !this.username.equals(input.username)) {
            throw new BadRequestException("username must match URL");
        }
        if (!ExternalId.isValidUsername(this.username)) {
            throw new BadRequestException("Invalid username '" + this.username + "'");
        }
        Set<AccountGroup.Id> groups = this.parseGroups(input.groups);
        Account.Id id = new Account.Id(this.db.nextAccountId());
        ExternalId extUser = ExternalId.createUsername(this.username, id, input.httpPassword);
        if (this.db.accountExternalIds().get(extUser.key().asAccountExternalIdKey()) != null) {
            throw new ResourceConflictException("username '" + this.username + "' already exists");
        }
        if (input.email != null) {
            if (this.db.accountExternalIds().get(ExternalId.Key.create("mailto", input.email).asAccountExternalIdKey()) != null) {
                throw new UnprocessableEntityException("email '" + input.email + "' already exists");
            }
            if (!OutgoingEmailValidator.isValid(input.email)) {
                throw new BadRequestException("invalid email address");
            }
        }
        ArrayList<ExternalId> extIds = new ArrayList<ExternalId>();
        extIds.add(extUser);
        for (AccountExternalIdCreator c : this.externalIdCreators) {
            extIds.addAll(c.create(id, this.username, input.email));
        }
        ExternalIdsUpdate externalIdsUpdate = this.externalIdsUpdateFactory.create();
        try {
            externalIdsUpdate.insert(this.db, extIds);
        }
        catch (OrmDuplicateKeyException duplicateKey) {
            throw new ResourceConflictException("username '" + this.username + "' already exists");
        }
        if (input.email != null) {
            try {
                externalIdsUpdate.insert(this.db, ExternalId.createEmail(id, input.email));
            }
            catch (OrmDuplicateKeyException duplicateKey) {
                try {
                    externalIdsUpdate.delete(this.db, extUser);
                }
                catch (OrmException | IOException exception) {
                    // empty catch block
                }
                throw new UnprocessableEntityException("email '" + input.email + "' already exists");
            }
        }
        Account a = new Account(id, TimeUtil.nowTs());
        a.setFullName(input.name);
        a.setPreferredEmail(input.email);
        this.db.accounts().insert(Collections.singleton(a));
        for (AccountGroup.Id groupId : groups) {
            AccountGroupMember m = new AccountGroupMember(new AccountGroupMember.Key(id, groupId));
            this.auditService.dispatchAddAccountsToGroup(this.currentUser.get().getAccountId(), Collections.singleton(m));
            this.db.accountGroupMembers().insert(Collections.singleton(m));
        }
        if (input.sshKey != null) {
            try {
                this.authorizedKeys.addKey(id, input.sshKey);
                this.sshKeyCache.evict(this.username);
            }
            catch (InvalidSshKeyException e) {
                throw new BadRequestException(e.getMessage());
            }
        }
        this.accountCache.evict(id);
        this.accountCache.evictByUsername(this.username);
        this.byEmailCache.evict(input.email);
        AccountLoader loader = this.infoLoader.create(true);
        AccountInfo info = loader.get(id);
        loader.fill();
        return Response.created(info);
    }

    private Set<AccountGroup.Id> parseGroups(List<String> groups) throws UnprocessableEntityException {
        HashSet<AccountGroup.Id> groupIds = new HashSet<AccountGroup.Id>();
        if (groups != null) {
            for (String g : groups) {
                groupIds.add(GroupDescriptions.toAccountGroup(this.groupsCollection.parseInternal(g)).getId());
            }
        }
        return groupIds;
    }

    public static interface Factory {
        public CreateAccount create(String var1);
    }
}

