/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.client.ProjectWatchInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class DeleteWatchedProjects
implements RestModifyView<AccountResource, List<ProjectWatchInfo>> {
    private final Provider<IdentifiedUser> self;
    private final AccountCache accountCache;
    private final WatchConfig.Accessor watchConfig;

    @Inject
    DeleteWatchedProjects(Provider<IdentifiedUser> self, AccountCache accountCache, WatchConfig.Accessor watchConfig) {
        this.self = self;
        this.accountCache = accountCache;
        this.watchConfig = watchConfig;
    }

    public Response<?> apply(AccountResource rsrc, List<ProjectWatchInfo> input) throws AuthException, UnprocessableEntityException, OrmException, IOException, ConfigInvalidException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser()) && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("It is not allowed to edit project watches of other users");
        }
        if (input == null) {
            return Response.none();
        }
        Account.Id accountId = rsrc.getUser().getAccountId();
        this.watchConfig.deleteProjectWatches(accountId, input.stream().map(w -> WatchConfig.ProjectWatchKey.create(new Project.NameKey(w.project), w.filter)).collect(Collectors.toList()));
        this.accountCache.evict(accountId);
        return Response.none();
    }
}

