/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class ExternalIds {
    public static final int MAX_NOTE_SZ = 524288;
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;

    public static ObjectId readRevision(Repository repo) throws IOException {
        Ref ref = repo.exactRef("refs/meta/external-ids");
        return ref != null ? ref.getObjectId() : ObjectId.zeroId();
    }

    public static NoteMap readNoteMap(RevWalk rw, ObjectId rev) throws IOException {
        if (!rev.equals(ObjectId.zeroId())) {
            return NoteMap.read(rw.getObjectReader(), rw.parseCommit(rev));
        }
        return NoteMap.newEmptyMap();
    }

    @Inject
    public ExternalIds(GitRepositoryManager repoManager, AllUsersName allUsersName) {
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
    }

    public ObjectId readRevision() throws IOException {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            ObjectId objectId = ExternalIds.readRevision(repo);
            return objectId;
        }
    }

    @Nullable
    public ExternalId get(ExternalId.Key key) throws IOException, ConfigInvalidException {
        Throwable throwable = null;
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            ExternalId externalId;
            ObjectId rev;
            Throwable throwable2;
            RevWalk rw;
            block13: {
                rw = new RevWalk(repo);
                throwable2 = null;
                rev = ExternalIds.readRevision(repo);
                if (!rev.equals(ObjectId.zeroId())) break block13;
                ExternalId externalId2 = null;
                ExternalIds.$closeResource(throwable2, rw);
                return externalId2;
            }
            try {
                externalId = this.parse(key, rw, rev);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        ExternalIds.$closeResource(throwable2, rw);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            ExternalIds.$closeResource(throwable2, rw);
            return externalId;
        }
    }

    private ExternalId parse(ExternalId.Key key, RevWalk rw, ObjectId rev) throws IOException, ConfigInvalidException {
        ObjectId noteId;
        NoteMap noteMap = ExternalIds.readNoteMap(rw, rev);
        if (!noteMap.contains(noteId = key.sha1())) {
            return null;
        }
        byte[] raw = rw.getObjectReader().open(noteMap.get(noteId), 3).getCachedBytes(524288);
        return ExternalId.parse(noteId.name(), raw);
    }
}

