/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.avatar.AvatarProvider;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class GetAvatarChangeUrl
implements RestReadView<AccountResource> {
    private final DynamicItem<AvatarProvider> avatarProvider;

    @Inject
    GetAvatarChangeUrl(DynamicItem<AvatarProvider> avatarProvider) {
        this.avatarProvider = avatarProvider;
    }

    public String apply(AccountResource rsrc) throws ResourceNotFoundException {
        AvatarProvider impl = this.avatarProvider.get();
        if (impl == null) {
            throw new ResourceNotFoundException();
        }
        String url = impl.getChangeAvatarUrl(rsrc.getUser());
        if (Strings.isNullOrEmpty(url)) {
            throw new ResourceNotFoundException();
        }
        return url;
    }
}

