/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.data.GroupDetail;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupControl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class GroupDetailFactory
implements Callable<GroupDetail> {
    private final ReviewDb db;
    private final GroupControl.Factory groupControl;
    private final GroupCache groupCache;
    private final AccountGroup.Id groupId;
    private GroupControl control;

    @Inject
    GroupDetailFactory(ReviewDb db, GroupControl.Factory groupControl, GroupCache groupCache, @Assisted AccountGroup.Id groupId) {
        this.db = db;
        this.groupControl = groupControl;
        this.groupCache = groupCache;
        this.groupId = groupId;
    }

    @Override
    public GroupDetail call() throws OrmException, NoSuchGroupException {
        this.control = this.groupControl.validateFor(this.groupId);
        AccountGroup group = this.groupCache.get(this.groupId);
        GroupDetail detail = new GroupDetail();
        detail.setGroup(group);
        detail.setMembers(this.loadMembers());
        detail.setIncludes(this.loadIncludes());
        return detail;
    }

    private List<AccountGroupMember> loadMembers() throws OrmException {
        ArrayList<AccountGroupMember> members = new ArrayList<AccountGroupMember>();
        for (AccountGroupMember m : this.db.accountGroupMembers().byGroup(this.groupId)) {
            if (!this.control.canSeeMember(m.getAccountId())) continue;
            members.add(m);
        }
        return members;
    }

    private List<AccountGroupById> loadIncludes() throws OrmException {
        ArrayList<AccountGroupById> groups = new ArrayList<AccountGroupById>();
        for (AccountGroupById m : this.db.accountGroupById().byGroup(this.groupId)) {
            if (!this.control.canSeeGroup()) continue;
            groups.add(m);
        }
        return groups;
    }

    public static interface Factory {
        public GroupDetailFactory create(AccountGroup.Id var1);
    }
}

