/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.errors.NameAlreadyUsedException;
import com.google.gerrit.extensions.client.AccountFieldName;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.ChangeUserName;
import com.google.gerrit.server.account.InvalidUserNameException;
import com.google.gerrit.server.account.Realm;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class PutUsername
implements RestModifyView<AccountResource, Input> {
    private final Provider<CurrentUser> self;
    private final ChangeUserName.Factory changeUserNameFactory;
    private final Realm realm;
    private final Provider<ReviewDb> db;

    @Inject
    PutUsername(Provider<CurrentUser> self, ChangeUserName.Factory changeUserNameFactory, Realm realm, Provider<ReviewDb> db) {
        this.self = self;
        this.changeUserNameFactory = changeUserNameFactory;
        this.realm = realm;
        this.db = db;
    }

    public String apply(AccountResource rsrc, Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, ResourceConflictException, OrmException, IOException, ConfigInvalidException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser()) && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("not allowed to set username");
        }
        if (!this.realm.allowsEdit(AccountFieldName.USER_NAME)) {
            throw new MethodNotAllowedException("realm does not allow editing username");
        }
        if (input == null) {
            input = new Input();
        }
        try {
            this.changeUserNameFactory.create(this.db.get(), rsrc.getUser(), input.username).call();
        }
        catch (IllegalStateException e) {
            if ("Username cannot be changed.".equals(e.getMessage())) {
                throw new MethodNotAllowedException(e.getMessage());
            }
            throw e;
        }
        catch (InvalidUserNameException e) {
            throw new UnprocessableEntityException("invalid username");
        }
        catch (NameAlreadyUsedException e) {
            throw new ResourceConflictException("username already used");
        }
        return input.username;
    }

    public static class Input {
        @DefaultInput
        public String username;
    }
}

