/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.accounts;

import com.google.gerrit.common.RawInputUtil;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.accounts.AccountApi;
import com.google.gerrit.extensions.api.accounts.EmailInput;
import com.google.gerrit.extensions.api.accounts.GpgKeyApi;
import com.google.gerrit.extensions.api.changes.StarsInput;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.extensions.client.EditPreferencesInfo;
import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.extensions.client.ProjectWatchInfo;
import com.google.gerrit.extensions.common.AccountExternalIdInfo;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.AgreementInfo;
import com.google.gerrit.extensions.common.AgreementInput;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.EmailInfo;
import com.google.gerrit.extensions.common.GpgKeyInfo;
import com.google.gerrit.extensions.common.SshKeyInfo;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.GpgException;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.AddSshKey;
import com.google.gerrit.server.account.CreateEmail;
import com.google.gerrit.server.account.DeleteActive;
import com.google.gerrit.server.account.DeleteEmail;
import com.google.gerrit.server.account.DeleteExternalIds;
import com.google.gerrit.server.account.DeleteSshKey;
import com.google.gerrit.server.account.DeleteWatchedProjects;
import com.google.gerrit.server.account.GetActive;
import com.google.gerrit.server.account.GetAgreements;
import com.google.gerrit.server.account.GetAvatar;
import com.google.gerrit.server.account.GetDiffPreferences;
import com.google.gerrit.server.account.GetEditPreferences;
import com.google.gerrit.server.account.GetEmails;
import com.google.gerrit.server.account.GetExternalIds;
import com.google.gerrit.server.account.GetPreferences;
import com.google.gerrit.server.account.GetSshKeys;
import com.google.gerrit.server.account.GetWatchedProjects;
import com.google.gerrit.server.account.Index;
import com.google.gerrit.server.account.PostWatchedProjects;
import com.google.gerrit.server.account.PutActive;
import com.google.gerrit.server.account.PutAgreement;
import com.google.gerrit.server.account.PutStatus;
import com.google.gerrit.server.account.SetDiffPreferences;
import com.google.gerrit.server.account.SetEditPreferences;
import com.google.gerrit.server.account.SetPreferences;
import com.google.gerrit.server.account.SshKeys;
import com.google.gerrit.server.account.StarredChanges;
import com.google.gerrit.server.account.Stars;
import com.google.gerrit.server.api.accounts.GpgApiAdapter;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.jgit.errors.ConfigInvalidException;

public class AccountApiImpl
implements AccountApi {
    private final AccountResource account;
    private final ChangesCollection changes;
    private final AccountLoader.Factory accountLoaderFactory;
    private final GetAvatar getAvatar;
    private final GetPreferences getPreferences;
    private final SetPreferences setPreferences;
    private final GetDiffPreferences getDiffPreferences;
    private final SetDiffPreferences setDiffPreferences;
    private final GetEditPreferences getEditPreferences;
    private final SetEditPreferences setEditPreferences;
    private final GetWatchedProjects getWatchedProjects;
    private final PostWatchedProjects postWatchedProjects;
    private final DeleteWatchedProjects deleteWatchedProjects;
    private final StarredChanges.Create starredChangesCreate;
    private final StarredChanges.Delete starredChangesDelete;
    private final Stars stars;
    private final Stars.Get starsGet;
    private final Stars.Post starsPost;
    private final GetEmails getEmails;
    private final CreateEmail.Factory createEmailFactory;
    private final DeleteEmail deleteEmail;
    private final GpgApiAdapter gpgApiAdapter;
    private final GetSshKeys getSshKeys;
    private final AddSshKey addSshKey;
    private final DeleteSshKey deleteSshKey;
    private final SshKeys sshKeys;
    private final GetAgreements getAgreements;
    private final PutAgreement putAgreement;
    private final GetActive getActive;
    private final PutActive putActive;
    private final DeleteActive deleteActive;
    private final Index index;
    private final GetExternalIds getExternalIds;
    private final DeleteExternalIds deleteExternalIds;
    private final PutStatus putStatus;

    @Inject
    AccountApiImpl(AccountLoader.Factory ailf, ChangesCollection changes, GetAvatar getAvatar, GetPreferences getPreferences, SetPreferences setPreferences, GetDiffPreferences getDiffPreferences, SetDiffPreferences setDiffPreferences, GetEditPreferences getEditPreferences, SetEditPreferences setEditPreferences, GetWatchedProjects getWatchedProjects, PostWatchedProjects postWatchedProjects, DeleteWatchedProjects deleteWatchedProjects, StarredChanges.Create starredChangesCreate, StarredChanges.Delete starredChangesDelete, Stars stars, Stars.Get starsGet, Stars.Post starsPost, GetEmails getEmails, CreateEmail.Factory createEmailFactory, DeleteEmail deleteEmail, GpgApiAdapter gpgApiAdapter, GetSshKeys getSshKeys, AddSshKey addSshKey, DeleteSshKey deleteSshKey, SshKeys sshKeys, GetAgreements getAgreements, PutAgreement putAgreement, GetActive getActive, PutActive putActive, DeleteActive deleteActive, Index index, GetExternalIds getExternalIds, DeleteExternalIds deleteExternalIds, PutStatus putStatus, @Assisted AccountResource account) {
        this.account = account;
        this.accountLoaderFactory = ailf;
        this.changes = changes;
        this.getAvatar = getAvatar;
        this.getPreferences = getPreferences;
        this.setPreferences = setPreferences;
        this.getDiffPreferences = getDiffPreferences;
        this.setDiffPreferences = setDiffPreferences;
        this.getEditPreferences = getEditPreferences;
        this.setEditPreferences = setEditPreferences;
        this.getWatchedProjects = getWatchedProjects;
        this.postWatchedProjects = postWatchedProjects;
        this.deleteWatchedProjects = deleteWatchedProjects;
        this.starredChangesCreate = starredChangesCreate;
        this.starredChangesDelete = starredChangesDelete;
        this.stars = stars;
        this.starsGet = starsGet;
        this.starsPost = starsPost;
        this.getEmails = getEmails;
        this.createEmailFactory = createEmailFactory;
        this.deleteEmail = deleteEmail;
        this.getSshKeys = getSshKeys;
        this.addSshKey = addSshKey;
        this.deleteSshKey = deleteSshKey;
        this.sshKeys = sshKeys;
        this.gpgApiAdapter = gpgApiAdapter;
        this.getAgreements = getAgreements;
        this.putAgreement = putAgreement;
        this.getActive = getActive;
        this.putActive = putActive;
        this.deleteActive = deleteActive;
        this.index = index;
        this.getExternalIds = getExternalIds;
        this.deleteExternalIds = deleteExternalIds;
        this.putStatus = putStatus;
    }

    @Override
    public AccountInfo get() throws RestApiException {
        AccountLoader accountLoader = this.accountLoaderFactory.create(true);
        try {
            AccountInfo ai = accountLoader.get(this.account.getUser().getAccountId());
            accountLoader.fill();
            return ai;
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot parse change", e);
        }
    }

    @Override
    public boolean getActive() throws RestApiException {
        Response<String> result = this.getActive.apply(this.account);
        return result.statusCode() == 200 && result.value().equals("ok");
    }

    @Override
    public void setActive(boolean active) throws RestApiException {
        try {
            if (active) {
                this.putActive.apply(this.account, new PutActive.Input());
            } else {
                this.deleteActive.apply(this.account, new DeleteActive.Input());
            }
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot set active", e);
        }
    }

    @Override
    public String getAvatarUrl(int size) throws RestApiException {
        this.getAvatar.setSize(size);
        return this.getAvatar.apply(this.account).location();
    }

    @Override
    public GeneralPreferencesInfo getPreferences() throws RestApiException {
        return this.getPreferences.apply(this.account);
    }

    @Override
    public GeneralPreferencesInfo setPreferences(GeneralPreferencesInfo in) throws RestApiException {
        try {
            return this.setPreferences.apply(this.account, in);
        }
        catch (IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot set preferences", e);
        }
    }

    @Override
    public DiffPreferencesInfo getDiffPreferences() throws RestApiException {
        try {
            return this.getDiffPreferences.apply(this.account);
        }
        catch (IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot query diff preferences", e);
        }
    }

    @Override
    public DiffPreferencesInfo setDiffPreferences(DiffPreferencesInfo in) throws RestApiException {
        try {
            return this.setDiffPreferences.apply(this.account, in);
        }
        catch (IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot set diff preferences", e);
        }
    }

    @Override
    public EditPreferencesInfo getEditPreferences() throws RestApiException {
        try {
            return this.getEditPreferences.apply(this.account);
        }
        catch (IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot query edit preferences", e);
        }
    }

    @Override
    public EditPreferencesInfo setEditPreferences(EditPreferencesInfo in) throws RestApiException {
        try {
            return this.setEditPreferences.apply(this.account, in);
        }
        catch (IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot set edit preferences", e);
        }
    }

    @Override
    public List<ProjectWatchInfo> getWatchedProjects() throws RestApiException {
        try {
            return this.getWatchedProjects.apply(this.account);
        }
        catch (OrmException | IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot get watched projects", e);
        }
    }

    @Override
    public List<ProjectWatchInfo> setWatchedProjects(List<ProjectWatchInfo> in) throws RestApiException {
        try {
            return this.postWatchedProjects.apply(this.account, in);
        }
        catch (OrmException | IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot update watched projects", e);
        }
    }

    @Override
    public void deleteWatchedProjects(List<ProjectWatchInfo> in) throws RestApiException {
        try {
            this.deleteWatchedProjects.apply(this.account, in);
        }
        catch (OrmException | IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot delete watched projects", e);
        }
    }

    @Override
    public void starChange(String changeId) throws RestApiException {
        try {
            ChangeResource rsrc = this.changes.parse(TopLevelResource.INSTANCE, IdString.fromUrl(changeId));
            this.starredChangesCreate.setChange(rsrc);
            this.starredChangesCreate.apply(this.account, new StarredChanges.EmptyInput());
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot star change", e);
        }
    }

    @Override
    public void unstarChange(String changeId) throws RestApiException {
        try {
            ChangeResource rsrc = this.changes.parse(TopLevelResource.INSTANCE, IdString.fromUrl(changeId));
            AccountResource.StarredChange starredChange = new AccountResource.StarredChange(this.account.getUser(), rsrc);
            this.starredChangesDelete.apply(starredChange, new StarredChanges.EmptyInput());
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot unstar change", e);
        }
    }

    @Override
    public void setStars(String changeId, StarsInput input) throws RestApiException {
        try {
            AccountResource.Star rsrc = this.stars.parse(this.account, IdString.fromUrl(changeId));
            this.starsPost.apply(rsrc, input);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot post stars", e);
        }
    }

    @Override
    public SortedSet<String> getStars(String changeId) throws RestApiException {
        try {
            AccountResource.Star rsrc = this.stars.parse(this.account, IdString.fromUrl(changeId));
            return this.starsGet.apply(rsrc);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot get stars", e);
        }
    }

    @Override
    public List<ChangeInfo> getStarredChanges() throws RestApiException {
        try {
            return this.stars.list().apply(this.account);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot get starred changes", e);
        }
    }

    @Override
    public List<EmailInfo> getEmails() {
        return this.getEmails.apply(this.account);
    }

    @Override
    public void addEmail(EmailInput input) throws RestApiException {
        AccountResource.Email rsrc = new AccountResource.Email(this.account.getUser(), input.email);
        try {
            this.createEmailFactory.create(input.email).apply(rsrc, input);
        }
        catch (EmailException | OrmException | IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot add email", e);
        }
    }

    @Override
    public void deleteEmail(String email) throws RestApiException {
        AccountResource.Email rsrc = new AccountResource.Email(this.account.getUser(), email);
        try {
            this.deleteEmail.apply(rsrc, null);
        }
        catch (OrmException | IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot delete email", e);
        }
    }

    @Override
    public void setStatus(String status) throws RestApiException {
        PutStatus.Input in = new PutStatus.Input(status);
        try {
            this.putStatus.apply(this.account, in);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot set status", e);
        }
    }

    @Override
    public List<SshKeyInfo> listSshKeys() throws RestApiException {
        try {
            return this.getSshKeys.apply(this.account);
        }
        catch (OrmException | IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot list SSH keys", e);
        }
    }

    @Override
    public SshKeyInfo addSshKey(String key) throws RestApiException {
        AddSshKey.Input in = new AddSshKey.Input();
        in.raw = RawInputUtil.create(key);
        try {
            return this.addSshKey.apply(this.account, in).value();
        }
        catch (OrmException | IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot add SSH key", e);
        }
    }

    @Override
    public void deleteSshKey(int seq) throws RestApiException {
        try {
            AccountResource.SshKey sshKeyRes = this.sshKeys.parse(this.account, IdString.fromDecoded(Integer.toString(seq)));
            this.deleteSshKey.apply(sshKeyRes, null);
        }
        catch (OrmException | IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot delete SSH key", e);
        }
    }

    @Override
    public Map<String, GpgKeyInfo> listGpgKeys() throws RestApiException {
        try {
            return this.gpgApiAdapter.listGpgKeys(this.account);
        }
        catch (GpgException e) {
            throw new RestApiException("Cannot list GPG keys", e);
        }
    }

    @Override
    public Map<String, GpgKeyInfo> putGpgKeys(List<String> add, List<String> delete) throws RestApiException {
        try {
            return this.gpgApiAdapter.putGpgKeys(this.account, add, delete);
        }
        catch (GpgException e) {
            throw new RestApiException("Cannot add GPG key", e);
        }
    }

    @Override
    public GpgKeyApi gpgKey(String id) throws RestApiException {
        try {
            return this.gpgApiAdapter.gpgKey(this.account, IdString.fromDecoded(id));
        }
        catch (GpgException e) {
            throw new RestApiException("Cannot get PGP key", e);
        }
    }

    @Override
    public List<AgreementInfo> listAgreements() throws RestApiException {
        return this.getAgreements.apply(this.account);
    }

    @Override
    public void signAgreement(String agreementName) throws RestApiException {
        try {
            AgreementInput input = new AgreementInput();
            input.name = agreementName;
            this.putAgreement.apply(this.account, input);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot sign agreement", e);
        }
    }

    @Override
    public void index() throws RestApiException {
        try {
            this.index.apply(this.account, new Index.Input());
        }
        catch (IOException e) {
            throw new RestApiException("Cannot index account", e);
        }
    }

    @Override
    public List<AccountExternalIdInfo> getExternalIds() throws RestApiException {
        try {
            return this.getExternalIds.apply(this.account);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot get external IDs", e);
        }
    }

    @Override
    public void deleteExternalIds(List<String> externalIds) throws RestApiException {
        try {
            this.deleteExternalIds.apply(this.account, externalIds);
        }
        catch (OrmException | IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot delete external IDs", e);
        }
    }

    static interface Factory {
        public AccountApiImpl create(AccountResource var1);
    }
}

