/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.Changes;
import com.google.gerrit.extensions.api.changes.CherryPickInput;
import com.google.gerrit.extensions.api.changes.CommentApi;
import com.google.gerrit.extensions.api.changes.DraftApi;
import com.google.gerrit.extensions.api.changes.DraftInput;
import com.google.gerrit.extensions.api.changes.FileApi;
import com.google.gerrit.extensions.api.changes.RebaseInput;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.api.changes.RevisionReviewerApi;
import com.google.gerrit.extensions.api.changes.RobotCommentApi;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.extensions.common.ActionInfo;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.common.FileInfo;
import com.google.gerrit.extensions.common.MergeableInfo;
import com.google.gerrit.extensions.common.RobotCommentInfo;
import com.google.gerrit.extensions.common.TestSubmitRuleInput;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.api.changes.CommentApiImpl;
import com.google.gerrit.server.api.changes.DraftApiImpl;
import com.google.gerrit.server.api.changes.FileApiImpl;
import com.google.gerrit.server.api.changes.RevisionReviewerApiImpl;
import com.google.gerrit.server.api.changes.RobotCommentApiImpl;
import com.google.gerrit.server.change.CherryPick;
import com.google.gerrit.server.change.Comments;
import com.google.gerrit.server.change.CreateDraftComment;
import com.google.gerrit.server.change.DeleteDraftPatchSet;
import com.google.gerrit.server.change.DraftComments;
import com.google.gerrit.server.change.FileResource;
import com.google.gerrit.server.change.Files;
import com.google.gerrit.server.change.GetDescription;
import com.google.gerrit.server.change.GetMergeList;
import com.google.gerrit.server.change.GetPatch;
import com.google.gerrit.server.change.GetRevisionActions;
import com.google.gerrit.server.change.ListRevisionComments;
import com.google.gerrit.server.change.ListRevisionDrafts;
import com.google.gerrit.server.change.ListRobotComments;
import com.google.gerrit.server.change.Mergeable;
import com.google.gerrit.server.change.PostReview;
import com.google.gerrit.server.change.PreviewSubmit;
import com.google.gerrit.server.change.PublishDraftPatchSet;
import com.google.gerrit.server.change.PutDescription;
import com.google.gerrit.server.change.Rebase;
import com.google.gerrit.server.change.RebaseUtil;
import com.google.gerrit.server.change.Reviewed;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.RevisionReviewers;
import com.google.gerrit.server.change.RobotComments;
import com.google.gerrit.server.change.Submit;
import com.google.gerrit.server.change.TestSubmitType;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

class RevisionApiImpl
implements RevisionApi {
    private final GitRepositoryManager repoManager;
    private final Changes changes;
    private final RevisionReviewers revisionReviewers;
    private final RevisionReviewerApiImpl.Factory revisionReviewerApi;
    private final CherryPick cherryPick;
    private final DeleteDraftPatchSet deleteDraft;
    private final Rebase rebase;
    private final RebaseUtil rebaseUtil;
    private final Submit submit;
    private final PreviewSubmit submitPreview;
    private final PublishDraftPatchSet publish;
    private final Reviewed.PutReviewed putReviewed;
    private final Reviewed.DeleteReviewed deleteReviewed;
    private final RevisionResource revision;
    private final Files files;
    private final Files.ListFiles listFiles;
    private final GetPatch getPatch;
    private final PostReview review;
    private final Mergeable mergeable;
    private final FileApiImpl.Factory fileApi;
    private final ListRevisionComments listComments;
    private final ListRobotComments listRobotComments;
    private final ListRevisionDrafts listDrafts;
    private final CreateDraftComment createDraft;
    private final DraftComments drafts;
    private final DraftApiImpl.Factory draftFactory;
    private final Comments comments;
    private final CommentApiImpl.Factory commentFactory;
    private final RobotComments robotComments;
    private final RobotCommentApiImpl.Factory robotCommentFactory;
    private final GetRevisionActions revisionActions;
    private final TestSubmitType testSubmitType;
    private final TestSubmitType.Get getSubmitType;
    private final Provider<GetMergeList> getMergeList;
    private final PutDescription putDescription;
    private final GetDescription getDescription;

    @Inject
    RevisionApiImpl(GitRepositoryManager repoManager, Changes changes, RevisionReviewers revisionReviewers, RevisionReviewerApiImpl.Factory revisionReviewerApi, CherryPick cherryPick, DeleteDraftPatchSet deleteDraft, Rebase rebase, RebaseUtil rebaseUtil, Submit submit, PreviewSubmit submitPreview, PublishDraftPatchSet publish, Reviewed.PutReviewed putReviewed, Reviewed.DeleteReviewed deleteReviewed, Files files, Files.ListFiles listFiles, GetPatch getPatch, PostReview review, Mergeable mergeable, FileApiImpl.Factory fileApi, ListRevisionComments listComments, ListRobotComments listRobotComments, ListRevisionDrafts listDrafts, CreateDraftComment createDraft, DraftComments drafts, DraftApiImpl.Factory draftFactory, Comments comments, CommentApiImpl.Factory commentFactory, RobotComments robotComments, RobotCommentApiImpl.Factory robotCommentFactory, GetRevisionActions revisionActions, TestSubmitType testSubmitType, TestSubmitType.Get getSubmitType, Provider<GetMergeList> getMergeList, PutDescription putDescription, GetDescription getDescription, @Assisted RevisionResource r) {
        this.repoManager = repoManager;
        this.changes = changes;
        this.revisionReviewers = revisionReviewers;
        this.revisionReviewerApi = revisionReviewerApi;
        this.cherryPick = cherryPick;
        this.deleteDraft = deleteDraft;
        this.rebase = rebase;
        this.rebaseUtil = rebaseUtil;
        this.review = review;
        this.submit = submit;
        this.submitPreview = submitPreview;
        this.publish = publish;
        this.files = files;
        this.putReviewed = putReviewed;
        this.deleteReviewed = deleteReviewed;
        this.listFiles = listFiles;
        this.getPatch = getPatch;
        this.mergeable = mergeable;
        this.fileApi = fileApi;
        this.listComments = listComments;
        this.robotComments = robotComments;
        this.listRobotComments = listRobotComments;
        this.listDrafts = listDrafts;
        this.createDraft = createDraft;
        this.drafts = drafts;
        this.draftFactory = draftFactory;
        this.comments = comments;
        this.commentFactory = commentFactory;
        this.robotCommentFactory = robotCommentFactory;
        this.revisionActions = revisionActions;
        this.testSubmitType = testSubmitType;
        this.getSubmitType = getSubmitType;
        this.getMergeList = getMergeList;
        this.putDescription = putDescription;
        this.getDescription = getDescription;
        this.revision = r;
    }

    @Override
    public void review(ReviewInput in) throws RestApiException {
        try {
            this.review.apply(this.revision, in);
        }
        catch (UpdateException | OrmException | IOException e) {
            throw new RestApiException("Cannot post review", e);
        }
    }

    @Override
    public void submit() throws RestApiException {
        SubmitInput in = new SubmitInput();
        this.submit(in);
    }

    @Override
    public void submit(SubmitInput in) throws RestApiException {
        try {
            this.submit.apply(this.revision, in);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot submit change", e);
        }
    }

    @Override
    public BinaryResult submitPreview() throws RestApiException {
        return this.submitPreview("zip");
    }

    @Override
    public BinaryResult submitPreview(String format) throws RestApiException {
        try {
            this.submitPreview.setFormat(format);
            return this.submitPreview.apply(this.revision);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot get submit preview", e);
        }
    }

    @Override
    public void publish() throws RestApiException {
        try {
            this.publish.apply(this.revision, new PublishDraftPatchSet.Input());
        }
        catch (UpdateException e) {
            throw new RestApiException("Cannot publish draft patch set", e);
        }
    }

    @Override
    public void delete() throws RestApiException {
        try {
            this.deleteDraft.apply(this.revision, null);
        }
        catch (UpdateException e) {
            throw new RestApiException("Cannot delete draft ps", e);
        }
    }

    @Override
    public ChangeApi rebase() throws RestApiException {
        RebaseInput in = new RebaseInput();
        return this.rebase(in);
    }

    @Override
    public ChangeApi rebase(RebaseInput in) throws RestApiException {
        try {
            return this.changes.id(this.rebase.apply((RevisionResource)this.revision, (RebaseInput)in)._number);
        }
        catch (EmailException | UpdateException | OrmException | IOException e) {
            throw new RestApiException("Cannot rebase ps", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canRebase() throws RestApiException {
        try {
            Throwable throwable = null;
            try (Repository repo = this.repoManager.openRepository(this.revision.getProject());){
                boolean bl;
                RevWalk rw = new RevWalk(repo);
                Throwable throwable2 = null;
                try {
                    bl = this.rebaseUtil.canRebase(this.revision.getPatchSet(), this.revision.getChange().getDest(), repo, rw);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            RevisionApiImpl.$closeResource(throwable2, rw);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                RevisionApiImpl.$closeResource(throwable2, rw);
                return bl;
            }
        }
        catch (IOException e) {
            throw new RestApiException("Cannot check if rebase is possible", e);
        }
    }

    @Override
    public ChangeApi cherryPick(CherryPickInput in) throws RestApiException {
        try {
            return this.changes.id(this.cherryPick.apply((RevisionResource)this.revision, (CherryPickInput)in)._number);
        }
        catch (UpdateException | OrmException | IOException e) {
            throw new RestApiException("Cannot cherry pick", e);
        }
    }

    @Override
    public RevisionReviewerApi reviewer(String id) throws RestApiException {
        try {
            return this.revisionReviewerApi.create(this.revisionReviewers.parse(this.revision, IdString.fromDecoded(id)));
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot parse reviewer", e);
        }
    }

    @Override
    public void setReviewed(String path, boolean reviewed) throws RestApiException {
        try {
            RestModifyView<FileResource, Reviewed.Input> view = reviewed ? this.putReviewed : this.deleteReviewed;
            view.apply(this.files.parse(this.revision, IdString.fromDecoded(path)), new Reviewed.Input());
        }
        catch (Exception e) {
            throw new RestApiException("Cannot update reviewed flag", e);
        }
    }

    @Override
    public Set<String> reviewed() throws RestApiException {
        try {
            return ImmutableSet.copyOf((Iterable)this.listFiles.setReviewed(true).apply(this.revision).value());
        }
        catch (PatchListNotAvailableException | OrmException | IOException e) {
            throw new RestApiException("Cannot list reviewed files", e);
        }
    }

    @Override
    public MergeableInfo mergeable() throws RestApiException {
        try {
            return this.mergeable.apply(this.revision);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot check mergeability", e);
        }
    }

    @Override
    public MergeableInfo mergeableOtherBranches() throws RestApiException {
        try {
            this.mergeable.setOtherBranches(true);
            return this.mergeable.apply(this.revision);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot check mergeability", e);
        }
    }

    @Override
    public Map<String, FileInfo> files() throws RestApiException {
        try {
            return (Map)this.listFiles.apply(this.revision).value();
        }
        catch (PatchListNotAvailableException | OrmException | IOException e) {
            throw new RestApiException("Cannot retrieve files", e);
        }
    }

    @Override
    public Map<String, FileInfo> files(String base) throws RestApiException {
        try {
            return (Map)this.listFiles.setBase(base).apply(this.revision).value();
        }
        catch (PatchListNotAvailableException | OrmException | IOException e) {
            throw new RestApiException("Cannot retrieve files", e);
        }
    }

    @Override
    public Map<String, FileInfo> files(int parentNum) throws RestApiException {
        try {
            return (Map)this.listFiles.setParent(parentNum).apply(this.revision).value();
        }
        catch (PatchListNotAvailableException | OrmException | IOException e) {
            throw new RestApiException("Cannot retrieve files", e);
        }
    }

    @Override
    public FileApi file(String path) {
        return this.fileApi.create(this.files.parse(this.revision, IdString.fromDecoded(path)));
    }

    @Override
    public Map<String, List<CommentInfo>> comments() throws RestApiException {
        try {
            return this.listComments.apply(this.revision);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve comments", e);
        }
    }

    @Override
    public Map<String, List<RobotCommentInfo>> robotComments() throws RestApiException {
        try {
            return this.listRobotComments.apply(this.revision);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve robot comments", e);
        }
    }

    @Override
    public List<CommentInfo> commentsAsList() throws RestApiException {
        try {
            return this.listComments.getComments(this.revision);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve comments", e);
        }
    }

    @Override
    public Map<String, List<CommentInfo>> drafts() throws RestApiException {
        try {
            return this.listDrafts.apply(this.revision);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve drafts", e);
        }
    }

    @Override
    public List<RobotCommentInfo> robotCommentsAsList() throws RestApiException {
        try {
            return this.listRobotComments.getComments(this.revision);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve robot comments", e);
        }
    }

    @Override
    public List<CommentInfo> draftsAsList() throws RestApiException {
        try {
            return this.listDrafts.getComments(this.revision);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve drafts", e);
        }
    }

    @Override
    public DraftApi draft(String id) throws RestApiException {
        try {
            return this.draftFactory.create(this.drafts.parse(this.revision, IdString.fromDecoded(id)));
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve draft", e);
        }
    }

    @Override
    public DraftApi createDraft(DraftInput in) throws RestApiException {
        try {
            String id = this.createDraft.apply((RevisionResource)this.revision, (DraftInput)in).value().id;
            return this.changes.id(this.revision.getChange().getId().get()).revision(this.revision.getPatchSet().getId().get()).draft(id);
        }
        catch (UpdateException | OrmException e) {
            throw new RestApiException("Cannot create draft", e);
        }
    }

    @Override
    public CommentApi comment(String id) throws RestApiException {
        try {
            return this.commentFactory.create(this.comments.parse(this.revision, IdString.fromDecoded(id)));
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve comment", e);
        }
    }

    @Override
    public RobotCommentApi robotComment(String id) throws RestApiException {
        try {
            return this.robotCommentFactory.create(this.robotComments.parse(this.revision, IdString.fromDecoded(id)));
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve robot comment", e);
        }
    }

    @Override
    public BinaryResult patch() throws RestApiException {
        try {
            return this.getPatch.apply(this.revision);
        }
        catch (IOException e) {
            throw new RestApiException("Cannot get patch", e);
        }
    }

    @Override
    public BinaryResult patch(String path) throws RestApiException {
        try {
            return this.getPatch.setPath(path).apply(this.revision);
        }
        catch (IOException e) {
            throw new RestApiException("Cannot get patch", e);
        }
    }

    @Override
    public Map<String, ActionInfo> actions() throws RestApiException {
        try {
            return this.revisionActions.apply(this.revision).value();
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot get actions", e);
        }
    }

    @Override
    public SubmitType submitType() throws RestApiException {
        try {
            return this.getSubmitType.apply(this.revision);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot get submit type", e);
        }
    }

    @Override
    public SubmitType testSubmitType(TestSubmitRuleInput in) throws RestApiException {
        try {
            return this.testSubmitType.apply(this.revision, in);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot test submit type", e);
        }
    }

    @Override
    public RevisionApi.MergeListRequest getMergeList() throws RestApiException {
        return new RevisionApi.MergeListRequest(){

            @Override
            public List<CommitInfo> get() throws RestApiException {
                try {
                    GetMergeList gml = (GetMergeList)RevisionApiImpl.this.getMergeList.get();
                    gml.setUninterestingParent(this.getUninterestingParent());
                    gml.setAddLinks(this.getAddLinks());
                    return gml.apply(RevisionApiImpl.this.revision).value();
                }
                catch (IOException e) {
                    throw new RestApiException("Cannot get merge list", e);
                }
            }
        };
    }

    @Override
    public void description(String description) throws RestApiException {
        PutDescription.Input in = new PutDescription.Input();
        in.description = description;
        try {
            this.putDescription.apply(this.revision, in);
        }
        catch (UpdateException e) {
            throw new RestApiException("Cannot set description", e);
        }
    }

    @Override
    public String description() throws RestApiException {
        return this.getDescription.apply(this.revision);
    }

    @Override
    public String etag() throws RestApiException {
        return this.revisionActions.getETag(this.revision);
    }

    static interface Factory {
        public RevisionApiImpl create(RevisionResource var1);
    }
}

