/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.projects;

import com.google.gerrit.extensions.api.projects.ProjectApi;
import com.google.gerrit.extensions.api.projects.ProjectInput;
import com.google.gerrit.extensions.api.projects.Projects;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.server.api.projects.ProjectApiImpl;
import com.google.gerrit.server.project.ListProjects;
import com.google.gerrit.server.project.ProjectsCollection;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.SortedMap;

@Singleton
class ProjectsImpl
implements Projects {
    private final ProjectsCollection projects;
    private final ProjectApiImpl.Factory api;
    private final Provider<ListProjects> listProvider;

    @Inject
    ProjectsImpl(ProjectsCollection projects, ProjectApiImpl.Factory api, Provider<ListProjects> listProvider) {
        this.projects = projects;
        this.api = api;
        this.listProvider = listProvider;
    }

    @Override
    public ProjectApi name(String name) throws RestApiException {
        try {
            return this.api.create(this.projects.parse(name));
        }
        catch (UnprocessableEntityException e) {
            return this.api.create(name);
        }
        catch (IOException e) {
            throw new RestApiException("Cannot retrieve project");
        }
    }

    @Override
    public ProjectApi create(String name) throws RestApiException {
        ProjectInput in = new ProjectInput();
        in.name = name;
        return this.create(in);
    }

    @Override
    public ProjectApi create(ProjectInput in) throws RestApiException {
        if (in.name == null) {
            throw new BadRequestException("input.name is required");
        }
        return this.name(in.name).create(in);
    }

    @Override
    public Projects.ListRequest list() {
        return new Projects.ListRequest(){

            @Override
            public SortedMap<String, ProjectInfo> getAsMap() throws RestApiException {
                return ProjectsImpl.this.list(this);
            }
        };
    }

    private SortedMap<String, ProjectInfo> list(Projects.ListRequest request) throws RestApiException {
        ListProjects.FilterType type;
        ListProjects lp = this.listProvider.get();
        lp.setShowDescription(request.getDescription());
        lp.setLimit(request.getLimit());
        lp.setStart(request.getStart());
        lp.setMatchPrefix(request.getPrefix());
        lp.setMatchSubstring(request.getSubstring());
        lp.setMatchRegex(request.getRegex());
        lp.setShowTree(request.getShowTree());
        for (String branch : request.getBranches()) {
            lp.addShowBranch(branch);
        }
        switch (request.getFilterType()) {
            case ALL: {
                type = ListProjects.FilterType.ALL;
                break;
            }
            case CODE: {
                type = ListProjects.FilterType.CODE;
                break;
            }
            case PARENT_CANDIDATES: {
                type = ListProjects.FilterType.PARENT_CANDIDATES;
                break;
            }
            case PERMISSIONS: {
                type = ListProjects.FilterType.PERMISSIONS;
                break;
            }
            default: {
                throw new BadRequestException("Unknown filter type: " + (Object)((Object)request.getFilterType()));
            }
        }
        lp.setFilterType(type);
        return lp.apply();
    }
}

