/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth.ldap;

import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.ParameterizedString;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.auth.ldap.Helper;
import com.google.gerrit.server.auth.ldap.LdapGroupMembership;
import com.google.gerrit.server.auth.ldap.LdapQuery;
import com.google.gerrit.server.auth.ldap.LdapRealm;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.login.LoginException;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapGroupBackend
implements GroupBackend {
    static final Logger log = LoggerFactory.getLogger(LdapGroupBackend.class);
    private static final String LDAP_NAME = "ldap/";
    private static final String GROUPNAME = "groupname";
    private final Helper helper;
    private final LoadingCache<String, Set<AccountGroup.UUID>> membershipCache;
    private final LoadingCache<String, Boolean> existsCache;
    private final ProjectCache projectCache;
    private final Provider<CurrentUser> userProvider;
    private final Config gerritConfig;

    @Inject
    LdapGroupBackend(Helper helper, @Named(value="ldap_groups") LoadingCache<String, Set<AccountGroup.UUID>> membershipCache, @Named(value="ldap_group_existence") LoadingCache<String, Boolean> existsCache, ProjectCache projectCache, Provider<CurrentUser> userProvider, @GerritServerConfig Config gerritConfig) {
        this.helper = helper;
        this.membershipCache = membershipCache;
        this.projectCache = projectCache;
        this.existsCache = existsCache;
        this.userProvider = userProvider;
        this.gerritConfig = gerritConfig;
    }

    private boolean isLdapUUID(AccountGroup.UUID uuid) {
        return uuid.get().startsWith("ldap:");
    }

    private static GroupReference groupReference(ParameterizedString p, LdapQuery.Result res) throws NamingException {
        return new GroupReference(new AccountGroup.UUID("ldap:" + res.getDN()), LDAP_NAME + LdapRealm.apply(p, res));
    }

    private static String cnFor(String dn) {
        try {
            LdapName name = new LdapName(dn);
            if (!name.isEmpty()) {
                String cn = name.get(name.size() - 1);
                int index = cn.indexOf(61);
                if (index >= 0) {
                    cn = cn.substring(index + 1);
                }
                return cn;
            }
        }
        catch (InvalidNameException e) {
            log.warn("Cannot parse LDAP dn for cn", e);
        }
        return dn;
    }

    @Override
    public boolean handles(AccountGroup.UUID uuid) {
        return this.isLdapUUID(uuid);
    }

    @Override
    public GroupDescription.Basic get(final AccountGroup.UUID uuid) {
        if (!this.handles(uuid)) {
            return null;
        }
        String groupDn = uuid.get().substring("ldap:".length());
        CurrentUser user = this.userProvider.get();
        if (!user.isIdentifiedUser() || !this.membershipsOf(user.asIdentifiedUser()).contains(uuid)) {
            try {
                if (!this.existsCache.get(groupDn).booleanValue()) {
                    return null;
                }
            }
            catch (ExecutionException e) {
                log.warn("Cannot lookup group {} in LDAP", (Object)groupDn, (Object)e);
                return null;
            }
        }
        final String name = LDAP_NAME + LdapGroupBackend.cnFor(groupDn);
        return new GroupDescription.Basic(){

            @Override
            public AccountGroup.UUID getGroupUUID() {
                return uuid;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            @Nullable
            public String getEmailAddress() {
                return null;
            }

            @Override
            @Nullable
            public String getUrl() {
                return null;
            }
        };
    }

    @Override
    public Collection<GroupReference> suggest(String name, ProjectControl project) {
        AccountGroup.UUID uuid = new AccountGroup.UUID(name);
        if (this.isLdapUUID(uuid)) {
            GroupDescription.Basic g = this.get(uuid);
            if (g == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(GroupReference.forGroup(g));
        }
        if (name.startsWith(LDAP_NAME)) {
            return this.suggestLdap(name.substring(LDAP_NAME.length()));
        }
        return Collections.emptySet();
    }

    @Override
    public GroupMembership membershipsOf(IdentifiedUser user) {
        String id = LdapGroupBackend.findId(user.state().getExternalIds());
        if (id == null) {
            return GroupMembership.EMPTY;
        }
        return new LdapGroupMembership(this.membershipCache, this.projectCache, id, this.gerritConfig);
    }

    private static String findId(Collection<ExternalId> extIds) {
        for (ExternalId extId : extIds) {
            if (!extId.isScheme("gerrit")) continue;
            return extId.key().id();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<GroupReference> suggestLdap(String name) {
        if (name.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<GroupReference> out = Sets.newTreeSet(GroupBackends.GROUP_REF_NAME_COMPARATOR);
        try {
            DirContext ctx = this.helper.open();
            try {
                name = Rdn.escapeValue(name) + (name.length() >= 3 ? "*" : "");
                Helper.LdapSchema schema = this.helper.getSchema(ctx);
                ParameterizedString filter = ParameterizedString.asis(schema.groupPattern.replace(GROUPNAME, name).toString());
                HashSet<String> returnAttrs = new HashSet<String>(schema.groupName.getParameterNames());
                Map<String, String> params = Collections.emptyMap();
                for (String groupBase : schema.groupBases) {
                    LdapQuery query = new LdapQuery(groupBase, schema.groupScope, filter, returnAttrs);
                    for (LdapQuery.Result res : query.query(ctx, params)) {
                        out.add(LdapGroupBackend.groupReference(schema.groupName, res));
                    }
                }
            }
            finally {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    log.warn("Cannot close LDAP query handle", e);
                }
            }
        }
        catch (NamingException | LoginException e) {
            log.warn("Cannot query LDAP for groups matching requested name", e);
        }
        return out;
    }

    @Override
    public boolean isVisibleToAll(AccountGroup.UUID uuid) {
        return this.handles(uuid) && this.helper.groupsVisibleToAll();
    }
}

