/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.auto.value.AutoValue;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.change.AutoValue_ChangeTriplet;
import java.util.Optional;

@AutoValue
public abstract class ChangeTriplet {
    public static String format(Change change) {
        return ChangeTriplet.format(change.getDest(), change.getKey());
    }

    private static String format(Branch.NameKey branch, Change.Key change) {
        return branch.getParentKey().get() + "~" + branch.getShortName() + "~" + change.get();
    }

    public static Optional<ChangeTriplet> parse(String triplet) {
        int t2 = triplet.lastIndexOf(126);
        int t1 = triplet.lastIndexOf(126, t2 - 1);
        if (t1 < 0 || t2 < 0) {
            return Optional.empty();
        }
        String project = Url.decode(triplet.substring(0, t1));
        String branch = Url.decode(triplet.substring(t1 + 1, t2));
        String changeId = Url.decode(triplet.substring(t2 + 1));
        AutoValue_ChangeTriplet result = new AutoValue_ChangeTriplet(new Branch.NameKey(new Project.NameKey(project), branch), new Change.Key(changeId));
        return Optional.of(result);
    }

    public final Project.NameKey project() {
        return this.branch().getParentKey();
    }

    public abstract Branch.NameKey branch();

    public abstract Change.Key id();

    public String toString() {
        return ChangeTriplet.format(this.branch(), this.id());
    }
}

