/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.change.FileContentUtil;
import com.google.gerrit.server.change.FileResource;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectState;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.args4j.Option;

public class DownloadContent
implements RestReadView<FileResource> {
    private final FileContentUtil fileContentUtil;
    @Option(name="--parent")
    private Integer parent;

    @Inject
    DownloadContent(FileContentUtil fileContentUtil) {
        this.fileContentUtil = fileContentUtil;
    }

    public BinaryResult apply(FileResource rsrc) throws ResourceNotFoundException, IOException, NoSuchChangeException, OrmException {
        String path = rsrc.getPatchKey().get();
        ProjectState projectState = rsrc.getRevision().getControl().getProjectControl().getProjectState();
        ObjectId revstr = ObjectId.fromString(rsrc.getRevision().getPatchSet().getRevision().get());
        return this.fileContentUtil.downloadContent(projectState, revstr, path, this.parent);
    }
}

