/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collections;

@Singleton
public class PutDescription
implements RestModifyView<RevisionResource, Input>,
UiAction<RevisionResource> {
    private final Provider<ReviewDb> dbProvider;
    private final ChangeMessagesUtil cmUtil;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final PatchSetUtil psUtil;

    @Inject
    PutDescription(Provider<ReviewDb> dbProvider, ChangeMessagesUtil cmUtil, BatchUpdate.Factory batchUpdateFactory, PatchSetUtil psUtil) {
        this.dbProvider = dbProvider;
        this.cmUtil = cmUtil;
        this.batchUpdateFactory = batchUpdateFactory;
        this.psUtil = psUtil;
    }

    public Response<String> apply(RevisionResource rsrc, Input input) throws UpdateException, RestApiException {
        ChangeControl ctl = rsrc.getControl();
        if (!ctl.canEditDescription()) {
            throw new AuthException("changing description not permitted");
        }
        Op op = new Op(input != null ? input : new Input(), rsrc.getPatchSet().getId());
        try (BatchUpdate u = this.batchUpdateFactory.create(this.dbProvider.get(), rsrc.getChange().getProject(), ctl.getUser(), TimeUtil.nowTs());){
            u.addOp(rsrc.getChange().getId(), op);
            u.execute();
        }
        return Strings.isNullOrEmpty(op.newDescription) ? Response.none() : Response.ok(op.newDescription);
    }

    @Override
    public UiAction.Description getDescription(RevisionResource rsrc) {
        return new UiAction.Description().setLabel("Edit Description").setVisible(rsrc.getControl().canEditDescription());
    }

    private class Op
    implements BatchUpdateOp {
        private final Input input;
        private final PatchSet.Id psId;
        private String oldDescription;
        private String newDescription;

        Op(Input input, PatchSet.Id psId) {
            this.input = input;
            this.psId = psId;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws OrmException {
            PatchSet ps = PutDescription.this.psUtil.get(ctx.getDb(), ctx.getNotes(), this.psId);
            ChangeUpdate update = ctx.getUpdate(this.psId);
            this.newDescription = Strings.nullToEmpty(this.input.description);
            this.oldDescription = Strings.nullToEmpty(ps.getDescription());
            if (this.oldDescription.equals(this.newDescription)) {
                return false;
            }
            String summary = this.oldDescription.isEmpty() ? "Description set to \"" + this.newDescription + "\"" : (this.newDescription.isEmpty() ? "Description \"" + this.oldDescription + "\" removed" : "Description changed to \"" + this.newDescription + "\"");
            ps.setDescription(this.newDescription);
            update.setPsDescription(this.newDescription);
            ctx.getDb().patchSets().update(Collections.singleton(ps));
            ChangeMessage cmsg = ChangeMessagesUtil.newMessage(this.psId, ctx.getUser(), ctx.getWhen(), summary, "autogenerated:gerrit:setPsDescription");
            PutDescription.this.cmUtil.addChangeMessage(ctx.getDb(), update, cmsg);
            return true;
        }
    }

    public static class Input {
        @DefaultInput
        public String description;
    }
}

