/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.restapi.MergeConflictException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.PatchSetInserter;
import com.google.gerrit.server.change.RebaseUtil;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.git.validators.CommitValidators;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.RepoContext;
import com.google.gwtorm.server.OrmException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class RebaseChangeOp
implements BatchUpdateOp {
    private final PatchSetInserter.Factory patchSetInserterFactory;
    private final MergeUtil.Factory mergeUtilFactory;
    private final RebaseUtil rebaseUtil;
    private final ChangeResource.Factory changeResourceFactory;
    private final ChangeControl ctl;
    private final PatchSet originalPatchSet;
    private String baseCommitish;
    private PersonIdent committerIdent;
    private boolean fireRevisionCreated = true;
    private CommitValidators.Policy validate;
    private boolean checkAddPatchSetPermission = true;
    private boolean forceContentMerge;
    private boolean copyApprovals = true;
    private boolean detailedCommitMessage;
    private boolean postMessage = true;
    private RevCommit rebasedCommit;
    private PatchSet.Id rebasedPatchSetId;
    private PatchSetInserter patchSetInserter;
    private PatchSet rebasedPatchSet;

    @AssistedInject
    RebaseChangeOp(PatchSetInserter.Factory patchSetInserterFactory, MergeUtil.Factory mergeUtilFactory, RebaseUtil rebaseUtil, ChangeResource.Factory changeResourceFactory, @Assisted ChangeControl ctl, @Assisted PatchSet originalPatchSet, @Assisted @Nullable String baseCommitish) {
        this.patchSetInserterFactory = patchSetInserterFactory;
        this.mergeUtilFactory = mergeUtilFactory;
        this.rebaseUtil = rebaseUtil;
        this.changeResourceFactory = changeResourceFactory;
        this.ctl = ctl;
        this.originalPatchSet = originalPatchSet;
        this.baseCommitish = baseCommitish;
    }

    public RebaseChangeOp setCommitterIdent(PersonIdent committerIdent) {
        this.committerIdent = committerIdent;
        return this;
    }

    public RebaseChangeOp setValidatePolicy(CommitValidators.Policy validate) {
        this.validate = validate;
        return this;
    }

    public RebaseChangeOp setCheckAddPatchSetPermission(boolean checkAddPatchSetPermission) {
        this.checkAddPatchSetPermission = checkAddPatchSetPermission;
        return this;
    }

    public RebaseChangeOp setFireRevisionCreated(boolean fireRevisionCreated) {
        this.fireRevisionCreated = fireRevisionCreated;
        return this;
    }

    public RebaseChangeOp setForceContentMerge(boolean forceContentMerge) {
        this.forceContentMerge = forceContentMerge;
        return this;
    }

    public RebaseChangeOp setCopyApprovals(boolean copyApprovals) {
        this.copyApprovals = copyApprovals;
        return this;
    }

    public RebaseChangeOp setDetailedCommitMessage(boolean detailedCommitMessage) {
        this.detailedCommitMessage = detailedCommitMessage;
        return this;
    }

    public RebaseChangeOp setPostMessage(boolean postMessage) {
        this.postMessage = postMessage;
        return this;
    }

    @Override
    public void updateRepo(RepoContext ctx) throws MergeConflictException, InvalidChangeOperationException, RestApiException, IOException, OrmException, NoSuchChangeException {
        String newCommitMessage;
        RevId oldRev = this.originalPatchSet.getRevision();
        RevWalk rw = ctx.getRevWalk();
        RevCommit original = rw.parseCommit(ObjectId.fromString(oldRev.get()));
        rw.parseBody(original);
        RevCommit baseCommit = this.baseCommitish != null ? rw.parseCommit(ctx.getRepository().resolve(this.baseCommitish)) : rw.parseCommit(this.rebaseUtil.findBaseRevision(this.originalPatchSet, this.ctl.getChange().getDest(), ctx.getRepository(), ctx.getRevWalk()));
        if (this.detailedCommitMessage) {
            rw.parseBody(baseCommit);
            newCommitMessage = this.newMergeUtil().createCommitMessageOnSubmit(original, baseCommit, this.ctl, this.originalPatchSet.getId());
        } else {
            newCommitMessage = original.getFullMessage();
        }
        this.rebasedCommit = this.rebaseCommit(ctx, original, baseCommit, newCommitMessage);
        RevId baseRevId = new RevId(this.baseCommitish != null ? this.baseCommitish : ObjectId.toString(baseCommit.getId()));
        RebaseUtil.Base base = this.rebaseUtil.parseBase(new RevisionResource(this.changeResourceFactory.create(this.ctl), this.originalPatchSet), baseRevId.get());
        this.rebasedPatchSetId = ChangeUtil.nextPatchSetId(ctx.getRepository(), this.ctl.getChange().currentPatchSetId());
        this.patchSetInserter = this.patchSetInserterFactory.create(this.ctl, this.rebasedPatchSetId, this.rebasedCommit).setDescription("Rebase").setDraft(this.originalPatchSet.isDraft()).setNotify(NotifyHandling.NONE).setFireRevisionCreated(this.fireRevisionCreated).setCopyApprovals(this.copyApprovals).setCheckAddPatchSetPermission(this.checkAddPatchSetPermission);
        if (this.postMessage) {
            this.patchSetInserter.setMessage("Patch Set " + this.rebasedPatchSetId.get() + ": Patch Set " + this.originalPatchSet.getId().get() + " was rebased");
        }
        if (base != null) {
            this.patchSetInserter.setGroups(base.patchSet().getGroups());
        }
        if (this.validate != null) {
            this.patchSetInserter.setValidatePolicy(this.validate);
        }
        this.patchSetInserter.updateRepo(ctx);
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws ResourceConflictException, OrmException, IOException {
        boolean ret = this.patchSetInserter.updateChange(ctx);
        this.rebasedPatchSet = this.patchSetInserter.getPatchSet();
        return ret;
    }

    @Override
    public void postUpdate(Context ctx) throws OrmException {
        this.patchSetInserter.postUpdate(ctx);
    }

    public RevCommit getRebasedCommit() {
        Preconditions.checkState(this.rebasedCommit != null, "getRebasedCommit() only valid after updateRepo");
        return this.rebasedCommit;
    }

    public PatchSet.Id getPatchSetId() {
        Preconditions.checkState(this.rebasedPatchSetId != null, "getPatchSetId() only valid after updateRepo");
        return this.rebasedPatchSetId;
    }

    public PatchSet getPatchSet() {
        Preconditions.checkState(this.rebasedPatchSet != null, "getPatchSet() only valid after executing update");
        return this.rebasedPatchSet;
    }

    private MergeUtil newMergeUtil() {
        ProjectState project = this.ctl.getProjectControl().getProjectState();
        return this.forceContentMerge ? this.mergeUtilFactory.create(project, true) : this.mergeUtilFactory.create(project);
    }

    private RevCommit rebaseCommit(RepoContext ctx, RevCommit original, ObjectId base, String commitMessage) throws ResourceConflictException, IOException {
        RevCommit parentCommit = original.getParent(0);
        if (base.equals(parentCommit)) {
            throw new ResourceConflictException("Change is already up to date.");
        }
        ThreeWayMerger merger = this.newMergeUtil().newThreeWayMerger(ctx.getRepository(), ctx.getInserter());
        merger.setBase(parentCommit);
        merger.merge(original, base);
        if (merger.getResultTreeId() == null) {
            throw new MergeConflictException("The change could not be rebased due to a conflict during merge.");
        }
        CommitBuilder cb = new CommitBuilder();
        cb.setTreeId(merger.getResultTreeId());
        cb.setParentId(base);
        cb.setAuthor(original.getAuthorIdent());
        cb.setMessage(commitMessage);
        if (this.committerIdent != null) {
            cb.setCommitter(this.committerIdent);
        } else {
            cb.setCommitter(ctx.getIdentifiedUser().newCommitterIdent(ctx.getWhen(), ctx.getTimeZone()));
        }
        ObjectId objectId = ctx.getInserter().insert(cb);
        ctx.getInserter().flush();
        return ctx.getRevWalk().parseCommit(objectId);
    }

    public static interface Factory {
        public RebaseChangeOp create(ChangeControl var1, PatchSet var2, @Nullable String var3);
    }
}

