/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.edit.ChangeEdit;
import com.google.gerrit.server.edit.ChangeEditUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@Singleton
public class Revisions
implements ChildCollection<ChangeResource, RevisionResource> {
    private final DynamicMap<RestView<RevisionResource>> views;
    private final Provider<ReviewDb> dbProvider;
    private final ChangeEditUtil editUtil;
    private final PatchSetUtil psUtil;

    @Inject
    Revisions(DynamicMap<RestView<RevisionResource>> views, Provider<ReviewDb> dbProvider, ChangeEditUtil editUtil, PatchSetUtil psUtil) {
        this.views = views;
        this.dbProvider = dbProvider;
        this.editUtil = editUtil;
        this.psUtil = psUtil;
    }

    @Override
    public DynamicMap<RestView<RevisionResource>> views() {
        return this.views;
    }

    @Override
    public RestView<ChangeResource> list() throws ResourceNotFoundException {
        throw new ResourceNotFoundException();
    }

    @Override
    public RevisionResource parse(ChangeResource change, IdString id) throws ResourceNotFoundException, AuthException, OrmException, IOException {
        if (id.get().equals("current")) {
            PatchSet ps = this.psUtil.current(this.dbProvider.get(), change.getNotes());
            if (ps != null && this.visible(change, ps)) {
                return new RevisionResource(change, ps).doNotCache();
            }
            throw new ResourceNotFoundException(id);
        }
        ArrayList<RevisionResource> match = Lists.newArrayListWithExpectedSize(2);
        for (RevisionResource rsrc : this.find(change, id.get())) {
            if (!this.visible(change, rsrc.getPatchSet())) continue;
            match.add(rsrc);
        }
        switch (match.size()) {
            case 0: {
                throw new ResourceNotFoundException(id);
            }
            case 1: {
                return (RevisionResource)match.get(0);
            }
        }
        throw new ResourceNotFoundException("Multiple patch sets for \"" + id.get() + "\": " + Joiner.on("; ").join(match));
    }

    private boolean visible(ChangeResource change, PatchSet ps) throws OrmException {
        return change.getControl().isPatchVisible(ps, this.dbProvider.get());
    }

    private List<RevisionResource> find(ChangeResource change, String id) throws OrmException, IOException, AuthException {
        if (id.equals("0") || id.equals("edit")) {
            return this.loadEdit(change, null);
        }
        if (id.length() < 6 && id.matches("^[1-9][0-9]{0,4}$")) {
            return this.byLegacyPatchSetId(change, id);
        }
        if (id.length() < 4 || id.length() > 40) {
            return Collections.emptyList();
        }
        ArrayList<RevisionResource> out = new ArrayList<RevisionResource>();
        for (PatchSet ps : this.psUtil.byChange(this.dbProvider.get(), change.getNotes())) {
            if (ps.getRevision() == null || !ps.getRevision().get().startsWith(id)) continue;
            out.add(new RevisionResource(change, ps));
        }
        if (out.isEmpty() && id.length() == 40) {
            return this.loadEdit(change, new RevId(id));
        }
        return out;
    }

    private List<RevisionResource> byLegacyPatchSetId(ChangeResource change, String id) throws OrmException {
        PatchSet ps = this.psUtil.get(this.dbProvider.get(), change.getNotes(), new PatchSet.Id(change.getId(), Integer.parseInt(id)));
        if (ps != null) {
            return Collections.singletonList(new RevisionResource(change, ps));
        }
        return Collections.emptyList();
    }

    private List<RevisionResource> loadEdit(ChangeResource change, RevId revid) throws AuthException, IOException, OrmException {
        Optional<ChangeEdit> edit = this.editUtil.byChange(change.getChange());
        if (edit.isPresent()) {
            PatchSet ps = new PatchSet(new PatchSet.Id(change.getId(), 0));
            ps.setRevision(edit.get().getRevision());
            if (revid == null || edit.get().getRevision().equals(revid)) {
                return Collections.singletonList(new RevisionResource(change, ps, edit));
            }
        }
        return Collections.emptyList();
    }
}

