/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.ReviewersUtil;
import com.google.gerrit.server.account.AccountVisibility;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.jgit.lib.Config;
import org.kohsuke.args4j.Option;

public class SuggestReviewers {
    private static final int DEFAULT_MAX_SUGGESTED = 10;
    protected final Provider<ReviewDb> dbProvider;
    protected final IdentifiedUser.GenericFactory identifiedUserFactory;
    protected final ReviewersUtil reviewersUtil;
    private final boolean suggestAccounts;
    private final int maxAllowed;
    private final int maxAllowedWithoutConfirmation;
    protected int limit;
    protected String query;
    protected final int maxSuggestedReviewers;

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="maximum number of reviewers to list")
    public void setLimit(int l) {
        this.limit = l <= 0 ? this.maxSuggestedReviewers : Math.min(l, this.maxSuggestedReviewers);
    }

    @Option(name="--query", aliases={"-q"}, metaVar="QUERY", usage="match reviewers query")
    public void setQuery(String q) {
        this.query = q;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean getSuggestAccounts() {
        return this.suggestAccounts;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getMaxAllowed() {
        return this.maxAllowed;
    }

    public int getMaxAllowedWithoutConfirmation() {
        return this.maxAllowedWithoutConfirmation;
    }

    @Inject
    public SuggestReviewers(AccountVisibility av, IdentifiedUser.GenericFactory identifiedUserFactory, Provider<ReviewDb> dbProvider, @GerritServerConfig Config cfg, ReviewersUtil reviewersUtil) {
        this.dbProvider = dbProvider;
        this.identifiedUserFactory = identifiedUserFactory;
        this.reviewersUtil = reviewersUtil;
        this.limit = this.maxSuggestedReviewers = cfg.getInt("suggest", "maxSuggestedReviewers", 10);
        String suggest = cfg.getString("suggest", null, "accounts");
        this.suggestAccounts = "OFF".equalsIgnoreCase(suggest) || "false".equalsIgnoreCase(suggest) ? false : av != AccountVisibility.NONE;
        this.maxAllowed = cfg.getInt("addreviewer", "maxAllowed", 20);
        this.maxAllowedWithoutConfirmation = cfg.getInt("addreviewer", "maxWithoutConfirmation", 10);
    }
}

