/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.GeneralPreferencesLoader;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GetPreferences;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Field;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresCapability(value="administrateServer")
@Singleton
public class SetPreferences
implements RestModifyView<ConfigResource, GeneralPreferencesInfo> {
    private static final Logger log = LoggerFactory.getLogger(SetPreferences.class);
    private final GeneralPreferencesLoader loader;
    private final GitRepositoryManager gitManager;
    private final Provider<MetaDataUpdate.User> metaDataUpdateFactory;
    private final AllUsersName allUsersName;
    private final AccountCache accountCache;

    @Inject
    SetPreferences(GeneralPreferencesLoader loader, GitRepositoryManager gitManager, Provider<MetaDataUpdate.User> metaDataUpdateFactory, AllUsersName allUsersName, AccountCache accountCache) {
        this.loader = loader;
        this.gitManager = gitManager;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.allUsersName = allUsersName;
        this.accountCache = accountCache;
    }

    public GeneralPreferencesInfo apply(ConfigResource rsrc, GeneralPreferencesInfo i) throws BadRequestException, IOException, ConfigInvalidException {
        if (!SetPreferences.hasSetFields(i)) {
            throw new BadRequestException("unsupported option");
        }
        return this.writeToGit(GetPreferences.readFromGit(this.gitManager, this.loader, this.allUsersName, i));
    }

    private GeneralPreferencesInfo writeToGit(GeneralPreferencesInfo i) throws RepositoryNotFoundException, IOException, ConfigInvalidException {
        try (MetaDataUpdate md = this.metaDataUpdateFactory.get().create(this.allUsersName);){
            VersionedAccountPreferences p = VersionedAccountPreferences.forDefault();
            p.load(md);
            ConfigUtil.storeSection(p.getConfig(), "general", null, i, GeneralPreferencesInfo.defaults());
            com.google.gerrit.server.account.SetPreferences.storeMyMenus(p, i.my);
            com.google.gerrit.server.account.SetPreferences.storeUrlAliases(p, i.urlAliases);
            p.commit(md);
            this.accountCache.evictAll();
            GeneralPreferencesInfo r = ConfigUtil.loadSection(p.getConfig(), "general", null, new GeneralPreferencesInfo(), GeneralPreferencesInfo.defaults(), null);
            GeneralPreferencesInfo generalPreferencesInfo = this.loader.loadMyMenusAndUrlAliases(r, p, null);
            return generalPreferencesInfo;
        }
    }

    private static boolean hasSetFields(GeneralPreferencesInfo in) {
        try {
            for (Field field : in.getClass().getDeclaredFields()) {
                if (ConfigUtil.skipField(field) || field.get(in) == null) continue;
                return true;
            }
        }
        catch (IllegalAccessException e) {
            log.warn("Unable to verify input", e);
        }
        return false;
    }
}

