/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.collect.Iterables;
import com.google.gerrit.server.config.SitePath;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;

@Singleton
public final class SitePaths {
    public static final String CSS_FILENAME = "GerritSite.css";
    public static final String HEADER_FILENAME = "GerritSiteHeader.html";
    public static final String FOOTER_FILENAME = "GerritSiteFooter.html";
    public final Path site_path;
    public final Path bin_dir;
    public final Path etc_dir;
    public final Path lib_dir;
    public final Path tmp_dir;
    public final Path logs_dir;
    public final Path plugins_dir;
    public final Path db_dir;
    public final Path data_dir;
    public final Path mail_dir;
    public final Path hooks_dir;
    public final Path static_dir;
    public final Path themes_dir;
    public final Path index_dir;
    public final Path gerrit_sh;
    public final Path gerrit_service;
    public final Path gerrit_socket;
    public final Path gerrit_war;
    public final Path gerrit_config;
    public final Path secure_config;
    public final Path ssl_keystore;
    public final Path ssh_key;
    public final Path ssh_rsa;
    public final Path ssh_dsa;
    public final Path ssh_ecdsa_256;
    public final Path ssh_ecdsa_384;
    public final Path ssh_ecdsa_521;
    public final Path ssh_ed25519;
    public final Path peer_keys;
    public final Path site_css;
    public final Path site_header;
    public final Path site_footer;
    public final Path site_gitweb;
    public final boolean isNew;

    @Inject
    public SitePaths(@SitePath Path sitePath) throws IOException {
        boolean isNew;
        this.site_path = sitePath;
        Path p = sitePath;
        this.bin_dir = p.resolve("bin");
        this.etc_dir = p.resolve("etc");
        this.lib_dir = p.resolve("lib");
        this.tmp_dir = p.resolve("tmp");
        this.plugins_dir = p.resolve("plugins");
        this.db_dir = p.resolve("db");
        this.data_dir = p.resolve("data");
        this.logs_dir = p.resolve("logs");
        this.mail_dir = this.etc_dir.resolve("mail");
        this.hooks_dir = p.resolve("hooks");
        this.static_dir = p.resolve("static");
        this.themes_dir = p.resolve("themes");
        this.index_dir = p.resolve("index");
        this.gerrit_sh = this.bin_dir.resolve("gerrit.sh");
        this.gerrit_service = this.bin_dir.resolve("gerrit.service");
        this.gerrit_socket = this.bin_dir.resolve("gerrit.socket");
        this.gerrit_war = this.bin_dir.resolve("gerrit.war");
        this.gerrit_config = this.etc_dir.resolve("gerrit.config");
        this.secure_config = this.etc_dir.resolve("secure.config");
        this.ssl_keystore = this.etc_dir.resolve("keystore");
        this.ssh_key = this.etc_dir.resolve("ssh_host_key");
        this.ssh_rsa = this.etc_dir.resolve("ssh_host_rsa_key");
        this.ssh_dsa = this.etc_dir.resolve("ssh_host_dsa_key");
        this.ssh_ecdsa_256 = this.etc_dir.resolve("ssh_host_ecdsa_key");
        this.ssh_ecdsa_384 = this.etc_dir.resolve("ssh_host_ecdsa_384_key");
        this.ssh_ecdsa_521 = this.etc_dir.resolve("ssh_host_ecdsa_521_key");
        this.ssh_ed25519 = this.etc_dir.resolve("ssh_host_ed25519_key");
        this.peer_keys = this.etc_dir.resolve("peer_keys");
        this.site_css = this.etc_dir.resolve(CSS_FILENAME);
        this.site_header = this.etc_dir.resolve(HEADER_FILENAME);
        this.site_footer = this.etc_dir.resolve(FOOTER_FILENAME);
        this.site_gitweb = this.etc_dir.resolve("gitweb_config.perl");
        try (DirectoryStream<Path> files = Files.newDirectoryStream(this.site_path);){
            isNew = Iterables.isEmpty(files);
        }
        catch (NoSuchFileException e) {
            isNew = true;
        }
        this.isNew = isNew;
    }

    public Path resolve(String path) {
        if (path != null && !path.isEmpty()) {
            Path loc = this.site_path.resolve(path).normalize();
            try {
                return loc.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                return loc.toAbsolutePath();
            }
        }
        return null;
    }
}

