/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.git.strategy.CommitMergeStatus;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ChangeControl;
import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class CodeReviewCommit
extends RevCommit {
    public static final Ordering<CodeReviewCommit> ORDER = Ordering.natural().onResultOf(c -> c.getPatchsetId() != null ? Integer.valueOf(c.getPatchsetId().getParentKey().get()) : null).nullsFirst();
    private PatchSet.Id patchsetId;
    private ChangeControl control;
    private CommitMergeStatus statusCode;

    public static CodeReviewRevWalk newRevWalk(Repository repo) {
        return new CodeReviewRevWalk(repo);
    }

    public static CodeReviewRevWalk newRevWalk(ObjectReader reader) {
        return new CodeReviewRevWalk(reader);
    }

    public CodeReviewCommit(AnyObjectId id) {
        super(id);
    }

    public ChangeNotes notes() {
        return this.getControl().getNotes();
    }

    public CommitMergeStatus getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(CommitMergeStatus statusCode) {
        this.statusCode = statusCode;
    }

    public PatchSet.Id getPatchsetId() {
        return this.patchsetId;
    }

    public void setPatchsetId(PatchSet.Id patchsetId) {
        this.patchsetId = patchsetId;
    }

    public void copyFrom(CodeReviewCommit src) {
        this.control = src.control;
        this.patchsetId = src.patchsetId;
        this.statusCode = src.statusCode;
    }

    public Change change() {
        return this.getControl().getChange();
    }

    public ChangeControl getControl() {
        return this.control;
    }

    public void setControl(ChangeControl control) {
        this.control = control;
    }

    public static class CodeReviewRevWalk
    extends RevWalk {
        private CodeReviewRevWalk(Repository repo) {
            super(repo);
        }

        private CodeReviewRevWalk(ObjectReader reader) {
            super(reader);
        }

        @Override
        protected CodeReviewCommit createCommit(AnyObjectId id) {
            return new CodeReviewCommit(id);
        }

        @Override
        public CodeReviewCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return (CodeReviewCommit)super.next();
        }

        @Override
        public void markStart(RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            Preconditions.checkArgument(c instanceof CodeReviewCommit);
            super.markStart(c);
        }

        @Override
        public void markUninteresting(RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            Preconditions.checkArgument(c instanceof CodeReviewCommit);
            super.markUninteresting(c);
        }

        @Override
        public CodeReviewCommit lookupCommit(AnyObjectId id) {
            return (CodeReviewCommit)super.lookupCommit(id);
        }

        @Override
        public CodeReviewCommit parseCommit(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return (CodeReviewCommit)super.parseCommit(id);
        }
    }
}

